/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.client.particle;

import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.client.ClientConfig;
import alexthw.eidolon_repraised.client.particle.SignParticleRenderType;
import alexthw.eidolon_repraised.event.ClientEvents;
import alexthw.eidolon_repraised.util.RenderUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class SignParticle
extends TextureSheetParticle {
    final Sign sign;

    public SignParticle(ClientLevel world, Sign sign, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.setPos(x, y, z);
        this.sign = sign;
        this.xd = vx;
        this.yd = vy;
        this.zd = vz;
        this.setLifetime(20);
        this.gravity = -0.05f;
        this.setColor(sign.getRed(), sign.getGreen(), sign.getBlue());
        this.updateTraits();
    }

    protected float getCoeff() {
        return (float)this.age / (float)this.lifetime;
    }

    protected void updateTraits() {
        float coeff = this.getCoeff();
        this.quadSize = Mth.lerp((float)coeff, (float)0.25f, (float)0.125f);
        this.setAlpha(Mth.lerp((float)(coeff * coeff), (float)0.75f, (float)0.0f));
    }

    public void tick() {
        this.updateTraits();
        super.tick();
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;
    }

    public void render(@NotNull VertexConsumer b, @NotNull Camera info, float pticks) {
        super.render((Boolean)ClientConfig.BETTER_LAYERING.get() != false ? ClientEvents.getDelayedRender().getBuffer(RenderUtil.GLOWING_BLOCK_PARTICLE) : b, info, pticks);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return SignParticleRenderType.INSTANCE;
    }
}

