package alexthw.eidolon_repraised.util;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.client.ClientRegistry;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat.Mode;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderStateShard.ShaderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

import java.util.Random;

public class RenderUtil {
    public static final RenderStateShard.TransparencyStateShard ADDITIVE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });

    public static final RenderStateShard.TransparencyStateShard NORMAL_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });

//    @OnlyIn(Dist.CLIENT)
//    public static class RescaledLightingState extends RenderStateShard.DiffuseLightingStateShard {
//        public RescaledLightingState() {
//            super(true);
//        }
//
//        @Override
//        public void setupRenderState() {
//            RenderSystem.enableLighting();
//            RenderSystem.enableRescaleNormal();
//        }
//
//        @Override
//        public void clearRenderState() {
//            RenderSystem.disableLighting();
//            RenderSystem.disableRescaleNormal();
//        }
//    }

    public static final RenderType GLOWING_SPRITE = RenderType.create(
            Eidolon.MODID + ":glowing_sprite",
            DefaultVertexFormat.POSITION_TEX_COLOR,
            Mode.QUADS, 256, true, false,
            RenderType.CompositeState.builder()
                    .setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, false))
                    .setLightmapState(new RenderStateShard.LightmapStateShard(false))
                    .setTransparencyState(ADDITIVE_TRANSPARENCY)
                    .setTextureState(new RenderStateShard.TextureStateShard(InventoryMenu.BLOCK_ATLAS, false, false))
                    .setShaderState(new ShaderStateShard(ClientRegistry::getGlowingSpriteShader))
                    .createCompositeState(false)
    );
    public static final RenderType GLOWING = RenderType.create(
            Eidolon.MODID + ":glowing",
            DefaultVertexFormat.POSITION_COLOR,
            Mode.QUADS, 256, true, false,
            RenderType.CompositeState.builder()
                    .setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, false))
                    .setLightmapState(new RenderStateShard.LightmapStateShard(false))
                    .setTransparencyState(ADDITIVE_TRANSPARENCY)
                    .setShaderState(new ShaderStateShard(ClientRegistry::getGlowingShader))
                    .createCompositeState(false)
    );
    public static final RenderType DELAYED_PARTICLE = RenderType.create(
            Eidolon.MODID + ":delayed_particle",
            DefaultVertexFormat.PARTICLE,
            Mode.QUADS, 256, true, false,
            RenderType.CompositeState.builder()
                    .setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, false))
                    .setTransparencyState(NORMAL_TRANSPARENCY)
                    .setTextureState(new RenderStateShard.TextureStateShard(TextureAtlas.LOCATION_PARTICLES, false, false))
                    .setShaderState(new ShaderStateShard(ClientRegistry::getSpriteParticleShader))
                    .createCompositeState(false)
    );
    public static final RenderType GLOWING_PARTICLE = RenderType.create(
            Eidolon.MODID + ":glowing_particle",
            DefaultVertexFormat.PARTICLE,
            Mode.QUADS, 256, true, false,
            RenderType.CompositeState.builder()
                    .setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, false))
                    .setLightmapState(new RenderStateShard.LightmapStateShard(false))
                    .setTransparencyState(ADDITIVE_TRANSPARENCY)
                    .setTextureState(new RenderStateShard.TextureStateShard(TextureAtlas.LOCATION_PARTICLES, false, false))
                    .setShaderState(new ShaderStateShard(ClientRegistry::getGlowingParticleShader))
                    .createCompositeState(false)
    );
    public static final RenderType GLOWING_BLOCK_PARTICLE = RenderType.create(
            Eidolon.MODID + ":glowing_particle",
            DefaultVertexFormat.PARTICLE,
            Mode.QUADS, 256, true, false,
            RenderType.CompositeState.builder()
                    .setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, false))
                    .setLightmapState(new RenderStateShard.LightmapStateShard(false))
                    .setTransparencyState(ADDITIVE_TRANSPARENCY)
                    .setTextureState(new RenderStateShard.TextureStateShard(InventoryMenu.BLOCK_ATLAS, false, false))
                    .setShaderState(new ShaderStateShard(ClientRegistry::getGlowingParticleShader))
                    .createCompositeState(false)
    );
    public static final RenderType VAPOR_TRANSLUCENT = RenderType.create(
            Eidolon.MODID + ":vapor_translucent",
            DefaultVertexFormat.BLOCK,
            Mode.QUADS, 256, true, false,
            RenderType.CompositeState.builder()
                    .setLightmapState(new RenderStateShard.LightmapStateShard(false))
                    .setTransparencyState(NORMAL_TRANSPARENCY)
                    .setTextureState(new RenderStateShard.TextureStateShard(InventoryMenu.BLOCK_ATLAS, false, false))
                    .setShaderState(new ShaderStateShard(ClientRegistry::getVaporShader))
                    .createCompositeState(false)
    );

    public static void litQuad(PoseStack mStack, MultiBufferSource buffer, double x, double y, double w, double h, float r, float g, float b, float a, TextureAtlasSprite sprite) {
        VertexConsumer builder = buffer.getBuffer(GLOWING_SPRITE);

        float f7 = sprite.getU0();
        float f8 = sprite.getU1();
        float f5 = sprite.getV0();
        float f6 = sprite.getV1();
        Matrix4f mat = mStack.last().pose();
        builder.addVertex(mat, (float) x, (float) y + (float) h, 0).setUv(f7, f6).setColor(r, g, b, a);
        builder.addVertex(mat, (float) x + (float) w, (float) y + (float) h, 0).setUv(f8, f6).setColor(r, g, b, a);
        builder.addVertex(mat, (float) x + (float) w, (float) y, 0).setUv(f8, f5).setColor(r, g, b, a);
        builder.addVertex(mat, (float) x, (float) y, 0).setUv(f7, f5).setColor(r, g, b, a);
    }

    public static void litQuad(PoseStack mStack, MultiBufferSource buffer, double x, double y, double w, double h, float r, float g, float b, TextureAtlasSprite sprite) {
        litQuad(mStack, buffer, x, y, w, h, r, g, b, 1.0f, sprite);
    }

    public static void litQuad(PoseStack mStack, MultiBufferSource buffer, double x, double y, double w, double h, float r, float g, float b, float u, float v, float uw, float vh) {
        VertexConsumer builder = buffer.getBuffer(GLOWING_SPRITE);

        Matrix4f mat = mStack.last().pose();
        builder.addVertex(mat, (float) x, (float) y + (float) h, 0).setUv(u, v + vh).setColor(r, g, b, 1.0f);
        builder.addVertex(mat, (float) x + (float) w, (float) y + (float) h, 0).setUv(u + uw, v + vh).setColor(r, g, b, 1.0f);
        builder.addVertex(mat, (float) x + (float) w, (float) y, 0).setUv(u + uw, v).setColor(r, g, b, 1.0f);
        builder.addVertex(mat, (float) x, (float) y, 0).setUv(u, v).setColor(r, g, b, 1.0f);
    }

    public static void litBillboard(PoseStack mStack, MultiBufferSource buffer, double x, double y, double z, float r, float g, float b, TextureAtlasSprite sprite) {
        VertexConsumer builder = buffer.getBuffer(GLOWING_SPRITE);
        Camera renderInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
        float f = (float) (x);
        float f1 = (float) (y);
        float f2 = (float) (z);
        Quaternionf quaternion = renderInfo.rotation().rotateY(135, new Quaternionf());
        float f7 = sprite.getU0();
        float f8 = sprite.getU1();
        float f5 = sprite.getV0();
        float f6 = sprite.getV1();
        mStack.pushPose();
        mStack.translate(f, f1, f2);
        mStack.mulPose(quaternion);
        Matrix4f mat = mStack.last().pose();
        float x0 = -0.5f, x1 = 0.5f, y0 = -0.5f, y1 = 0.5f, z0 = 0.0f;
        builder.addVertex(mat, x0, y0, z0).setUv(f8, f6).setColor(r, g, b, 1.0f);
        builder.addVertex(mat, x0, y1, z0).setUv(f8, f5).setColor(r, g, b, 1.0f);
        builder.addVertex(mat, x1, y1, z0).setUv(f7, f5).setColor(r, g, b, 1.0f);
        builder.addVertex(mat, x1, y0, z0).setUv(f7, f6).setColor(r, g, b, 1.0f);
        mStack.popPose();

    }

    public static void dragon(PoseStack mStack, MultiBufferSource buf, double x, double y, double z, float radius, float r, float g, float b) {
        float f5 = 0.5f; // max number of beams
        //float f7 = Math.min(f5 > 0.8F ? (f5 - 0.8F) / 0.2F : 0.0F, 1.0F);
        float f7 = 0.0F;
        Random random = new Random(432L);
        VertexConsumer builder = buf.getBuffer(GLOWING);
        mStack.pushPose();
        mStack.translate(x, y, z);

        float rotation = ClientInfo.getClientPartialTicks() / 200;

        for(int i = 0; (float)i < (f5 + f5 * f5) / 2.0F * 60.0F; ++i) {
            mStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0F));
            mStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0F));
            mStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0F));
            mStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0F));
            mStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0F));
            mStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0F + rotation * 90.0F));
            float f3 = random.nextFloat() * 20.0F + 5.0F + f7 * 10.0F;
            float f4 = random.nextFloat() * 2.0F + 1.0F + f7 * 2.0F;
            f3 *= 0.05f * radius;
            f4 *= 0.05f * radius;
            Matrix4f mat = mStack.last().pose();
            float alpha = 1 - f7;

            builder.addVertex(mat, 0.0F, 0.0F, 0.0F).setColor(r, g, b, alpha);
            builder.addVertex(mat, 0.0F, 0.0F, 0.0F).setColor(r, g, b, alpha);
            builder.addVertex(mat, -ROOT_3 * f4, f3, -0.5F * f4).setColor(r, g, b, 0);
            builder.addVertex(mat, ROOT_3 * f4, f3, -0.5F * f4).setColor(r, g, b, 0);
            builder.addVertex(mat, 0.0F, 0.0F, 0.0F).setColor(r, g, b, alpha);
            builder.addVertex(mat, 0.0F, 0.0F, 0.0F).setColor(r, g, b, alpha);
            builder.addVertex(mat, ROOT_3 * f4, f3, -0.5F * f4).setColor(r, g, b, 0);
            builder.addVertex(mat, 0.0F, f3, f4).setColor(r, g, b, 0);
            builder.addVertex(mat, 0.0F, 0.0F, 0.0F).setColor(r, g, b, alpha);
            builder.addVertex(mat, 0.0F, 0.0F, 0.0F).setColor(r, g, b, alpha);
            builder.addVertex(mat, 0.0F, f3, f4).setColor(r, g, b, 0);
            builder.addVertex(mat, -ROOT_3 * f4, f3, -0.5F * f4).setColor(r, g, b, 0);
        }

        mStack.popPose();
    }

    private static final float ROOT_3 = (float)(Math.sqrt(3.0D) / 2.0D);

    public static void vaporCube(PoseStack mStack, VertexConsumer builder, TextureAtlasSprite sprite,
                                 float x1, float y1, float z1, float x2, float y2, float z2,
                                 int r, int g, int b, int a, int light,
                                 boolean nx, boolean px, boolean ny, boolean py, boolean nz, boolean pz) {
        Matrix4f mat = mStack.last().pose();
        if (py) {
            builder.addVertex(mat, x1, y2, z1).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16), sprite.getV(x1 * 16)).setLight(light).setNormal(0, 1, 0);
            builder.addVertex(mat, x1, y2, z2).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16), sprite.getV(x1 * 16)).setLight(light).setNormal(0, 1, 0);
            builder.addVertex(mat, x2, y2, z2).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16), sprite.getV(x2 * 16)).setLight(light).setNormal(0, 1, 0);
            builder.addVertex(mat, x2, y2, z1).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16), sprite.getV(x2 * 16)).setLight(light).setNormal(0, 1, 0);
        }
        if (ny) {
            builder.addVertex(mat, x1, y1, z2).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16), sprite.getV(x1 * 16)).setLight(light).setNormal(0, -1, 0);
            builder.addVertex(mat, x1, y1, z1).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16), sprite.getV(x1 * 16)).setLight(light).setNormal(0, -1, 0);
            builder.addVertex(mat, x2, y1, z1).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16), sprite.getV(x2 * 16)).setLight(light).setNormal(0, -1, 0);
            builder.addVertex(mat, x2, y1, z2).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16), sprite.getV(x2 * 16)).setLight(light).setNormal(0, -1, 0);
        }
        if (nz) {
            builder.addVertex(mat, x2, y1, z1).setColor(r, g, b, a).setUv(sprite.getU(x1 * 16), sprite.getV(y1 * 16)).setLight(light).setNormal(0, 0, -1);
            builder.addVertex(mat, x1, y1, z1).setColor(r, g, b, a).setUv(sprite.getU(x2 * 16), sprite.getV(y1 * 16)).setLight(light).setNormal(0, 0, -1);
            builder.addVertex(mat, x1, y2, z1).setColor(r, g, b, a).setUv(sprite.getU(x2 * 16), sprite.getV(y2 * 16)).setLight(light).setNormal(0, 0, -1);
            builder.addVertex(mat, x2, y2, z1).setColor(r, g, b, a).setUv(sprite.getU(x1 * 16), sprite.getV(y2 * 16)).setLight(light).setNormal(0, 0, -1);
        }
        if (pz) {
            builder.addVertex(mat, x1, y1, z2).setColor(r, g, b, a).setUv(sprite.getU(x1 * 16), sprite.getV(y1 * 16)).setLight(light).setNormal(0, 0, 1);
            builder.addVertex(mat, x2, y1, z2).setColor(r, g, b, a).setUv(sprite.getU(x2 * 16), sprite.getV(y1 * 16)).setLight(light).setNormal(0, 0, 1);
            builder.addVertex(mat, x2, y2, z2).setColor(r, g, b, a).setUv(sprite.getU(x2 * 16), sprite.getV(y2 * 16)).setLight(light).setNormal(0, 0, 1);
            builder.addVertex(mat, x1, y2, z2).setColor(r, g, b, a).setUv(sprite.getU(x1 * 16), sprite.getV(y2 * 16)).setLight(light).setNormal(0, 0, 1);
        }
        if (nx) {
            builder.addVertex(mat, x1, y1, z1).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16), sprite.getV(y1 * 16)).setLight(light).setNormal(-1, 0, 0);
            builder.addVertex(mat, x1, y1, z2).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16), sprite.getV(y1 * 16)).setLight(light).setNormal(-1, 0, 0);
            builder.addVertex(mat, x1, y2, z2).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16), sprite.getV(y2 * 16)).setLight(light).setNormal(-1, 0, 0);
            builder.addVertex(mat, x1, y2, z1).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16), sprite.getV(y2 * 16)).setLight(light).setNormal(-1, 0, 0);
        }
        if (px) {
            builder.addVertex(mat, x2, y1, z2).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16), sprite.getV(y1 * 16)).setLight(light).setNormal(1, 0, 0);
            builder.addVertex(mat, x2, y1, z1).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16), sprite.getV(y1 * 16)).setLight(light).setNormal(1, 0, 0);
            builder.addVertex(mat, x2, y2, z1).setColor(r, g, b, a).setUv(sprite.getU(z2 * 16), sprite.getV(y2 * 16)).setLight(light).setNormal(1, 0, 0);
            builder.addVertex(mat, x2, y2, z2).setColor(r, g, b, a).setUv(sprite.getU(z1 * 16), sprite.getV(y2 * 16)).setLight(light).setNormal(1, 0, 0);
        }
    }
}
