/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.recipe;

import alexthw.eidolon_repraised.api.ritual.Ritual;
import alexthw.eidolon_repraised.common.ritual.LocationRitual;
import alexthw.eidolon_repraised.recipe.RitualRecipe;
import alexthw.eidolon_repraised.registries.EidolonRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;

public class LocationRitualRecipe
extends RitualRecipe {
    ResourceLocation structureTagKey;

    public ResourceLocation getStructureTagKey() {
        return this.structureTagKey;
    }

    public LocationRitualRecipe(ResourceLocation structure, Ingredient reagent, List<Ingredient> pedestalItems, List<Ingredient> focusItems, float healthRequirement) {
        super(reagent, pedestalItems, focusItems, healthRequirement);
        this.structureTagKey = structure;
    }

    @Override
    public Ritual getRitual() {
        return new LocationRitual((TagKey<Structure>)TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)this.structureTagKey)).setRegistryName(this.getId());
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)this.structureTagKey.getNamespace(), (String)("ritual_locate_" + this.structureTagKey.getPath()));
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EidolonRecipes.LOCATION_RITUAL_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)EidolonRecipes.LOCATION_RITUAL_TYPE.get();
    }

    public static class Serializer
    extends RitualRecipe.Serializer<LocationRitualRecipe> {
        public static final MapCodec<LocationRitualRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("structure").forGetter(recipe -> recipe.structureTagKey), (App)Ingredient.CODEC.fieldOf("reagent").forGetter(RitualRecipe::getReagent), (App)Ingredient.CODEC.listOf().fieldOf("pedestal_items").forGetter(RitualRecipe::getPedestalItems), (App)Ingredient.CODEC.listOf().fieldOf("focus_items").forGetter(RitualRecipe::getFocusItems), (App)Codec.FLOAT.fieldOf("health_requirement").orElse((Object)Float.valueOf(0.0f)).forGetter(RitualRecipe::getHealthRequirement)).apply((Applicative)instance, LocationRitualRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, LocationRitualRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, LocationRitualRecipe::getStructureTagKey, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RitualRecipe::getReagent, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), RitualRecipe::getPedestalItems, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), RitualRecipe::getFocusItems, (StreamCodec)ByteBufCodecs.FLOAT, RitualRecipe::getHealthRequirement, LocationRitualRecipe::new);

        @NotNull
        public MapCodec<LocationRitualRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, LocationRitualRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

