/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.event;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.capability.ISoul;
import alexthw.eidolon_repraised.api.ritual.Ritual;
import alexthw.eidolon_repraised.capability.KnowledgeCommand;
import alexthw.eidolon_repraised.capability.ReputationCommand;
import alexthw.eidolon_repraised.capability.SoulImpl;
import alexthw.eidolon_repraised.capability.WingsDataImpl;
import alexthw.eidolon_repraised.common.entity.ZombieBruteEntity;
import alexthw.eidolon_repraised.common.entity.ai.FollowOwnerGoal;
import alexthw.eidolon_repraised.common.entity.ai.PriestBarterGoal;
import alexthw.eidolon_repraised.common.entity.ai.ThrallTargetGoal;
import alexthw.eidolon_repraised.common.entity.ai.WitchBarterGoal;
import alexthw.eidolon_repraised.common.item.BonelordArmorItem;
import alexthw.eidolon_repraised.common.item.CleavingAxeItem;
import alexthw.eidolon_repraised.common.item.CodexItem;
import alexthw.eidolon_repraised.common.item.ReaperScytheItem;
import alexthw.eidolon_repraised.common.item.SummoningStaffItem;
import alexthw.eidolon_repraised.common.item.WarlockRobesItem;
import alexthw.eidolon_repraised.common.spell.ThrallSpell;
import alexthw.eidolon_repraised.common.tile.GobletTileEntity;
import alexthw.eidolon_repraised.network.CrystallizeEffectPacket;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.network.OpenCodexPacket;
import alexthw.eidolon_repraised.network.SoulUpdatePacket;
import alexthw.eidolon_repraised.network.WingsDataUpdatePacket;
import alexthw.eidolon_repraised.registries.EidolonAttributes;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.registries.EidolonPotions;
import alexthw.eidolon_repraised.registries.Registry;
import alexthw.eidolon_repraised.registries.Signs;
import alexthw.eidolon_repraised.util.EntityUtil;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.Nullable;

public class Events {
    public static InteractionResult rightClickLectern(Player player, Level world, BlockHitResult hit) {
        BlockPos pos = hit.getBlockPos();
        BlockState state = world.getBlockState(pos);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof LecternBlockEntity) {
            LecternBlockEntity lectern = (LecternBlockEntity)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (((Boolean)state.getValue((Property)LecternBlock.HAS_BOOK)).booleanValue() && lectern.getBook().getItem() instanceof CodexItem) {
                    player.playNotifySound(SoundEvents.BOOK_PAGE_TURN, SoundSource.PLAYERS, 1.0f, 1.0f);
                    Networking.sendToPlayerClient(new OpenCodexPacket(), serverPlayer);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        KnowledgeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ReputationCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onTarget(LivingChangeTargetEvent event) {
        if (!EntityUtil.isEnthralled(event.getEntity())) {
            return;
        }
        UUID master = event.getEntity().getPersistentData().getUUID("eidolon_repraised:thrall");
        LivingEntity newTarget = null;
        if (EntityUtil.isEnthralledBy(event.getEntity(), event.getNewAboutToBeSetTarget())) {
            LivingEntity lastHurt = event.getNewAboutToBeSetTarget().getLastHurtMob();
            LivingEntity lastHurtBy = event.getNewAboutToBeSetTarget().getLastHurtByMob();
            newTarget = Events.handleEnthralledTargeting(lastHurt, lastHurtBy, event.getEntity());
        } else {
            ServerLevel server;
            Level lastHurt = event.getEntity().level();
            if (lastHurt instanceof ServerLevel && (lastHurt = (server = (ServerLevel)lastHurt).getEntity(master)) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)lastHurt;
                lastHurt = living.getLastHurtMob();
                LivingEntity lastHurtBy = living.getLastHurtByMob();
                newTarget = Events.handleEnthralledTargeting((LivingEntity)lastHurt, lastHurtBy, event.getEntity());
            }
        }
        if (!(event.getEntity() instanceof HoglinBase) || newTarget != null) {
            event.setNewAboutToBeSetTarget(newTarget);
        }
    }

    @Nullable
    public static LivingEntity handleEnthralledTargeting(@Nullable LivingEntity lastHurt, @Nullable LivingEntity lastHurtBy, LivingEntity thrall) {
        if (lastHurtBy != null && lastHurtBy != thrall && !thrall.isAlliedTo((Entity)lastHurtBy)) {
            return lastHurtBy;
        }
        if (lastHurt != null && lastHurt != thrall && !thrall.isAlliedTo((Entity)lastHurt)) {
            return lastHurt;
        }
        if (thrall.getLastHurtByMob() != null && !thrall.isAlliedTo((Entity)thrall.getLastHurtByMob())) {
            return thrall.getLastHurtByMob();
        }
        return null;
    }

    @SubscribeEvent
    public void onTick(EntityTickEvent.Pre event) {
        SoulImpl s;
        Level level = event.getEntity().level();
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity e = (LivingEntity)entity;
        if (e.hasEffect(EidolonPotions.UNDEATH_EFFECT) && level.isDay() && !level.isClientSide) {
            BlockPos blockpos;
            float f = e.getLightLevelDependentMagicValue();
            BlockPos blockPos = blockpos = e.getVehicle() instanceof Boat ? BlockPos.containing((double)e.getX(), (double)Math.round(e.getY()), (double)e.getZ()).above() : BlockPos.containing((double)e.getX(), (double)Math.round(e.getY()), (double)e.getZ());
            if (f > 0.5f && e.getRandom().nextFloat() * 30.0f < (f - 0.4f) * 2.0f && level.canSeeSky(blockpos)) {
                e.setRemainingFireTicks(160);
            }
        }
        boolean hasBoneArmor = false;
        for (ItemStack s2 : e.getArmorSlots()) {
            if (!(s2.getItem() instanceof BonelordArmorItem)) continue;
            hasBoneArmor = true;
            break;
        }
        if (hasBoneArmor && (double)e.getHealth() >= (double)e.getMaxHealth() * 0.999 && event.getEntity().tickCount % 80 == 0 && (s = (SoulImpl)e.getCapability(EidolonCapabilities.SOUL_HEART_CAPABILITY)) != null) {
            if (s.getEtherealHealth() < ISoul.getPersistentHealth(e)) {
                s.setMaxEtherealHealth(Math.max(Math.min(ISoul.getPersistentHealth(e), s.getMaxEtherealHealth()), (float)(2 * Mth.floor((float)((s.getEtherealHealth() + 2.0f) / 2.0f)))));
            }
            s.healEtherealHealth(1.0f, ISoul.getPersistentHealth(e));
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDropsEvent event) {
        Entity item2;
        BlockPos pos;
        Level world;
        List<GobletTileEntity> goblets;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Monster) && !(goblets = Ritual.getTilesWithinAABB(GobletTileEntity.class, world = entity.level(), new AABB((pos = entity.blockPosition()).offset(-2, -2, -2).getBottomCenter(), pos.offset(3, 3, 3).getCenter()))).isEmpty()) {
            GobletTileEntity goblet = goblets.stream().min(Comparator.comparingDouble(g -> g.getBlockPos().distSqr((Vec3i)pos))).get();
            goblet.setEntityType(entity.getType());
        }
        if (event.getSource().getEntity() instanceof Player && !entity.level().isClientSide()) {
            Calendar calendar = Calendar.getInstance();
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            if ((month == 10 && day >= 28 || month == 11 && day <= 2) && entity.level().random.nextInt(10) == 0) {
                if (entity instanceof Zombie) {
                    event.getDrops().add(new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)Registry.RED_CANDY.get())));
                } else if (entity instanceof AbstractSkeleton) {
                    event.getDrops().add(new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)Registry.GRAPE_CANDY.get())));
                }
            }
        }
        if ((entity instanceof Witch || entity instanceof Villager) && entity.getMainHandItem().getItem() instanceof CodexItem) {
            event.getDrops().add(new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), entity.getMainHandItem().copy()));
        }
        if (entity instanceof ZombieBruteEntity && (entity.hasEffect(MobEffects.WITHER) || event.getSource().is(DamageTypes.WITHER)) && !entity.level().isClientSide) {
            for (Entity item2 : event.getDrops()) {
                if (!item2.getItem().is((Item)Registry.ZOMBIE_HEART.get())) continue;
                item2.setItem(new ItemStack((ItemLike)Registry.WITHERED_HEART.get(), item2.getItem().getCount()));
            }
        }
        if (event.getSource().getEntity() != null && (item2 = event.getSource().getEntity()) instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)item2;
            ItemStack held = source.getMainHandItem();
            Optional lootingHolder = source.level().registryAccess().holder(Enchantments.LOOTING);
            if (!entity.level().isClientSide && (held.getItem() instanceof ReaperScytheItem || event.getSource().is(Registry.RITUAL_DAMAGE.key)) && Eidolon.isValidUndead(entity)) {
                if (!(entity instanceof Player)) {
                    event.getDrops().removeIf(i -> !(i.getItem().getItem() instanceof ArmorItem));
                }
                int looting = lootingHolder.map(enchantmentReference -> EnchantmentHelper.getEnchantmentLevel((Holder)enchantmentReference, (LivingEntity)source)).orElse(0);
                if (source.hasEffect(EidolonPotions.SOUL_HARVEST)) {
                    looting += 2;
                }
                ItemEntity drop = new ItemEntity(source.level(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)Registry.SOUL_SHARD.get(), source.level().random.nextInt(2 + looting)));
                drop.setDefaultPickUpDelay();
                event.getDrops().add(drop);
                Networking.sendToNearbyClient(entity.level(), entity.blockPosition(), (CustomPacketPayload)new CrystallizeEffectPacket(entity.blockPosition()));
            }
            if (!entity.level().isClientSide && held.getItem() instanceof CleavingAxeItem) {
                int looting = lootingHolder.map(enchantmentReference -> EnchantmentHelper.getEnchantmentLevel((Holder)enchantmentReference, (LivingEntity)source)).orElse(0);
                Events.beheading(event, source, entity, looting);
            }
        }
    }

    private static void beheading(LivingDropsEvent event, LivingEntity source, LivingEntity entity, int looting) {
        ItemStack head = ItemStack.EMPTY;
        if (entity instanceof WitherSkeleton) {
            head = new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL);
        } else if (entity instanceof Skeleton) {
            head = new ItemStack((ItemLike)Items.SKELETON_SKULL);
        } else if (entity instanceof Zombie) {
            head = new ItemStack((ItemLike)Items.ZOMBIE_HEAD);
        } else if (entity instanceof Creeper) {
            head = new ItemStack((ItemLike)Items.CREEPER_HEAD);
        } else if (entity instanceof EnderDragon) {
            head = new ItemStack((ItemLike)Items.DRAGON_HEAD);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            head = new ItemStack((ItemLike)Items.PLAYER_HEAD);
            head.set(DataComponents.PROFILE, (Object)new ResolvableProfile(player.getGameProfile()));
        }
        if (!head.isEmpty()) {
            boolean doDrop = false;
            if (entity.level().random.nextInt(20) == 0) {
                doDrop = true;
            } else {
                for (int i = 0; i < looting; ++i) {
                    if (entity.level().random.nextInt(40) != 0) continue;
                    doDrop = true;
                    break;
                }
            }
            for (ItemEntity e : event.getDrops()) {
                if (!e.getItem().is(head.getItem())) continue;
                doDrop = false;
            }
            if (doDrop) {
                ItemEntity drop = new ItemEntity(source.level(), entity.getX(), entity.getY(), entity.getZ(), head);
                drop.setDefaultPickUpDelay();
                event.getDrops().add(drop);
            }
        }
    }

    @SubscribeEvent
    public void registerCustomAI(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof LivingEntity && !event.getLevel().isClientSide) {
            PathfinderMob mob;
            Entity entity = event.getEntity();
            if (entity instanceof Witch) {
                Witch witch = (Witch)entity;
                witch.goalSelector.addGoal(1, (Goal)new WitchBarterGoal(witch, stack -> stack.getItem() == Registry.CODEX.get(), stack -> CodexItem.withSign(stack, Signs.WICKED_SIGN)));
            }
            if ((entity = event.getEntity()) instanceof Villager) {
                Villager villager = (Villager)entity;
                villager.goalSelector.addGoal(1, (Goal)new PriestBarterGoal(villager, stack -> stack.getItem() == Registry.CODEX.get(), stack -> CodexItem.withSign(stack, Signs.SACRED_SIGN)));
            }
            if ((entity = event.getEntity()) instanceof PathfinderMob && ((mob = (PathfinderMob)entity).getNavigation() instanceof GroundPathNavigation || mob.getNavigation() instanceof FlyingPathNavigation)) {
                mob.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal(mob, LivingEntity.class, 6.0f, 1.0, 1.2, living -> Eidolon.isValidUndead((LivingEntity)mob) && !EntityUtil.isEnthralled((LivingEntity)mob) && living.hasEffect(EidolonPotions.LIGHT_BLESSED)));
                if (mob.getType().is(ThrallSpell.ENTHRALL_WHITELIST) || mob.getType().is(EntityTypeTags.UNDEAD) && !mob.getType().is(ThrallSpell.ENTHRALL_BLACKLIST)) {
                    try {
                        mob.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((Mob)mob, 1.5, 3.0f, 1.2f));
                        mob.targetSelector.addGoal(1, (Goal)new ThrallTargetGoal(mob));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        WingsDataImpl wings = (WingsDataImpl)event.getEntity().getCapability(EidolonCapabilities.WINGS_CAPABILITY);
        if (wings != null && !wings.getWingsItem(event.getEntity()).isEmpty()) {
            Player player;
            if (event.getEntity().isCrouching() && event.getEntity().getDeltaMovement().y < -0.1) {
                wings.startFlying(event.getEntity());
                event.getEntity().setDeltaMovement(event.getEntity().getDeltaMovement().x, -0.1, event.getEntity().getDeltaMovement().z);
            }
            if (wings.isFlying(event.getEntity())) {
                event.getEntity().resetFallDistance();
            }
            if (wings.isDashing(event.getEntity())) {
                wings.doDashTick(event.getEntity());
            }
            if (event.getEntity().onGround()) {
                wings.rechargeWings(event.getEntity());
                wings.stopFlying(event.getEntity());
            }
            if ((player = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Networking.sendToPlayerClient(new WingsDataUpdatePacket(event.getEntity()), serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUse(LivingEntityUseItemEvent.Start event) {
        if (event.getEntity().hasEffect(EidolonPotions.UNDEATH_EFFECT) && event.getItem().getFoodProperties(event.getEntity()) != null && !event.getItem().is(Registry.ZOMBIE_FOOD_TAG)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @Deprecated
    public void onPotionApplicable(MobEffectEvent.Added event) {
        if (event.getEntity().hasEffect(MobEffects.HUNGER) && event.getEffectInstance().getEffect() == EidolonPotions.UNDEATH_EFFECT.get()) {
            event.getEntity().removeEffect(MobEffects.HUNGER);
        }
    }

    @SubscribeEvent
    public void onPotionApplicable(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance().getEffect() == MobEffects.MOVEMENT_SLOWDOWN && event.getEntity().getItemBySlot(EquipmentSlot.FEET).getItem() instanceof WarlockRobesItem) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
        if (event.getEntity().hasEffect(EidolonPotions.UNDEATH_EFFECT) && event.getEffectInstance().getEffect() == MobEffects.HUNGER) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
        if (event.getEntity().getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof BonelordArmorItem && (event.getEffectInstance().getEffect() == MobEffects.WITHER || event.getEffectInstance().getEffect() == MobEffects.POISON)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingDamageEvent.Pre event) {
        SoulImpl soul;
        LivingEntity living;
        Entity attribute;
        Entity entity;
        boolean isMagic = event.getSource().is(Tags.DamageTypes.IS_MAGIC);
        boolean isWither = event.getSource().getMsgId().equals(event.getEntity().damageSources().wither().getMsgId());
        if (isMagic && (entity = event.getSource().getEntity()) instanceof LivingEntity && (attribute = (living = (LivingEntity)entity).getAttribute(EidolonAttributes.MAGIC_POWER)) != null) {
            event.setNewDamage(event.getNewDamage() * (float)attribute.getValue());
        }
        if (isWither && (attribute = event.getSource().getEntity()) instanceof LivingEntity && (living = (LivingEntity)attribute).getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof WarlockRobesItem) {
            event.setNewDamage(event.getNewDamage() * 1.5f);
            living.heal(event.getNewDamage() / 2.0f);
        }
        if ((isMagic || isWither) && event.getEntity().getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof WarlockRobesItem) {
            event.setNewDamage(event.getNewDamage() / 2.0f);
        }
        if ((soul = (SoulImpl)event.getEntity().getCapability(EidolonCapabilities.SOUL_HEART_CAPABILITY)) != null && soul.hasEtherealHealth()) {
            float reduced = soul.hurtEtherealHealth(event.getNewDamage(), ISoul.getPersistentHealth(event.getEntity()));
            event.setNewDamage(reduced);
            if (event.getEntity() instanceof ServerPlayer) {
                Networking.sendToPlayerClient(new SoulUpdatePacket(event.getEntity()), (ServerPlayer)event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingIncomingDamageEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity;
            if (EntityUtil.isEnthralledBy(event.getEntity(), source)) {
                Item item = source.getMainHandItem().getItem();
                if (item instanceof SummoningStaffItem) {
                    SummoningStaffItem summoningStaffItem = (SummoningStaffItem)item;
                    CompoundTag eTag = event.getEntity().serializeNBT((HolderLookup.Provider)event.getEntity().registryAccess());
                    event.getEntity().remove(Entity.RemovalReason.KILLED);
                    summoningStaffItem.addCharge(source.getMainHandItem(), eTag);
                    event.setCanceled(true);
                }
            } else if (EntityUtil.isEnthralledBy(source, event.getEntity())) {
                event.setCanceled(true);
            } else if (EntityUtil.sameMaster(event.getEntity(), source)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onExpDrop(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() != null && event.getAttackingPlayer().hasEffect(EidolonPotions.SOUL_HARVEST)) {
            event.setDroppedExperience(Mth.ceil((double)((double)event.getDroppedExperience() * 1.25)));
        }
    }
}

