/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.datagen;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.registries.Registry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EidItemTagProvider
extends ItemTagsProvider {
    public static final TagKey<Item> SCRIBE_ITEMS = EidItemTagProvider.eidolonItemTag("scribe_items");
    public static final TagKey<Item> PATRON_SYMBOL = EidItemTagProvider.eidolonItemTag("patron_symbol");

    public EidItemTagProvider(DataGenerator pGenerator, CompletableFuture<HolderLookup.Provider> provider, BlockTagsProvider pBlockTagsProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(pGenerator.getPackOutput(), provider, pBlockTagsProvider.contentsGetter(), "eidolon_repraised", existingFileHelper);
    }

    @NotNull
    private static TagKey<Item> eidolonItemTag(String name) {
        return ItemTags.create((ResourceLocation)Eidolon.prefix(name));
    }

    protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.tag(Tags.Items.MUSIC_DISCS).add((Object)((Item)Registry.PAROUSIA_DISC.get()));
        this.tag(SCRIBE_ITEMS).add((Object[])new Item[]{Items.CHARCOAL, Items.FEATHER, Items.BOOK, ((Block)Registry.CANDLE.get()).asItem(), (Item)Registry.PARCHMENT.get(), (Item)Registry.MAGIC_INK.get()});
        this.tag(PATRON_SYMBOL).add((Object[])new Item[]{(Item)Registry.HOLY_SYMBOL.get(), (Item)Registry.UNHOLY_SYMBOL.get()});
        this.copy(BlockTags.SAPLINGS, ItemTags.SAPLINGS);
        this.copy(BlockTags.LEAVES, ItemTags.LEAVES);
        this.copy(BlockTags.WOODEN_BUTTONS, ItemTags.WOODEN_BUTTONS);
        this.copy(BlockTags.CANDLES, ItemTags.CANDLES);
        this.tag(ItemTags.BOOKSHELF_BOOKS).add((Object)((Item)Registry.CODEX.get()));
        this.tag(ItemTags.LECTERN_BOOKS).add((Object)((Item)Registry.CODEX.get()));
        this.tag(ItemTags.SIGNS).add((Object[])new Item[]{Registry.ILLWOOD_PLANKS.getStandingSign().asItem(), Registry.POLISHED_PLANKS.getStandingSign().asItem()});
        this.copy(BlockTags.WOODEN_PRESSURE_PLATES, ItemTags.WOODEN_PRESSURE_PLATES);
        Object[] armors = new Item[]{(Item)Registry.SILVER_HELMET.get(), (Item)Registry.SILVER_CHESTPLATE.get(), (Item)Registry.SILVER_LEGGINGS.get(), (Item)Registry.SILVER_BOOTS.get(), (Item)Registry.WARLOCK_HAT.get(), (Item)Registry.WARLOCK_CLOAK.get(), (Item)Registry.WARLOCK_BOOTS.get(), (Item)Registry.BONELORD_HELM.get(), (Item)Registry.BONELORD_CHESTPLATE.get(), (Item)Registry.BONELORD_GREAVES.get()};
        this.tag(ItemTags.ARMOR_ENCHANTABLE).add(armors);
        this.tag(ItemTags.EQUIPPABLE_ENCHANTABLE).add(armors);
        this.tag(ItemTags.DURABILITY_ENCHANTABLE).add(armors);
        this.tag(ItemTags.HEAD_ARMOR).add((Object[])new Item[]{(Item)Registry.SILVER_HELMET.get(), (Item)Registry.WARLOCK_HAT.get(), (Item)Registry.BONELORD_HELM.get()});
        this.tag(ItemTags.HEAD_ARMOR_ENCHANTABLE).add((Object[])new Item[]{(Item)Registry.SILVER_HELMET.get(), (Item)Registry.WARLOCK_HAT.get(), (Item)Registry.BONELORD_HELM.get()});
        this.tag(ItemTags.CHEST_ARMOR).add((Object[])new Item[]{(Item)Registry.SILVER_CHESTPLATE.get(), (Item)Registry.WARLOCK_CLOAK.get(), (Item)Registry.BONELORD_CHESTPLATE.get()});
        this.tag(ItemTags.CHEST_ARMOR_ENCHANTABLE).add((Object[])new Item[]{(Item)Registry.SILVER_CHESTPLATE.get(), (Item)Registry.WARLOCK_CLOAK.get(), (Item)Registry.BONELORD_CHESTPLATE.get()});
        this.tag(ItemTags.LEG_ARMOR).add((Object[])new Item[]{(Item)Registry.SILVER_LEGGINGS.get(), (Item)Registry.BONELORD_GREAVES.get()});
        this.tag(ItemTags.LEG_ARMOR_ENCHANTABLE).add((Object[])new Item[]{(Item)Registry.SILVER_LEGGINGS.get(), (Item)Registry.BONELORD_GREAVES.get()});
        this.tag(ItemTags.FOOT_ARMOR).add((Object[])new Item[]{(Item)Registry.SILVER_BOOTS.get(), (Item)Registry.WARLOCK_BOOTS.get()});
        this.tag(ItemTags.FOOT_ARMOR_ENCHANTABLE).add((Object[])new Item[]{(Item)Registry.SILVER_BOOTS.get(), (Item)Registry.WARLOCK_BOOTS.get()});
        this.tag(Tags.Items.NUGGETS).add((Object[])new Item[]{(Item)Registry.LEAD_NUGGET.get(), (Item)Registry.SILVER_NUGGET.get(), (Item)Registry.PEWTER_NUGGET.get(), (Item)Registry.ARCANE_GOLD_NUGGET.get()});
    }
}

