/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.datagen;

import alexthw.eidolon_repraised.registries.Registry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EidBlockTagProvider
extends BlockTagsProvider {
    public EidBlockTagProvider(DataGenerator pGenerator, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
        super(pGenerator.getPackOutput(), provider, "eidolon_repraised", existingFileHelper);
    }

    protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.tag(BlockTags.LEAVES).add((Object)((Block)Registry.ILLWOOD_LEAVES.get()));
        this.tag(BlockTags.MINEABLE_WITH_HOE).add((Object)((Block)Registry.ILLWOOD_LEAVES.get()));
        this.tag(BlockTags.SAPLINGS).add((Object)((Block)Registry.ILLWOOD_SAPLING.get()));
        this.tag(BlockTags.WOODEN_BUTTONS).add((Object[])new Block[]{Registry.ILLWOOD_PLANKS.getButton(), Registry.POLISHED_PLANKS.getButton()});
        this.tag(BlockTags.WALL_SIGNS).add((Object[])new Block[]{Registry.ILLWOOD_PLANKS.getWallSign(), Registry.POLISHED_PLANKS.getWallSign()});
        this.tag(BlockTags.STANDING_SIGNS).add((Object[])new Block[]{Registry.ILLWOOD_PLANKS.getStandingSign(), Registry.POLISHED_PLANKS.getStandingSign()});
        this.tag(BlockTags.WOODEN_PRESSURE_PLATES).add((Object[])new Block[]{Registry.ILLWOOD_PLANKS.getPressurePlate(), Registry.POLISHED_PLANKS.getPressurePlate()});
        this.tag(Registry.CRUCIBLE_HOT_BLOCKS).add((Object[])new Block[]{Blocks.MAGMA_BLOCK, Blocks.FIRE, Blocks.SOUL_FIRE, Blocks.LAVA});
        this.tag(BlockTags.CANDLES).add((Object[])new Block[]{(Block)Registry.CANDLE.get(), (Block)Registry.CANDLESTICK.get(), (Block)Registry.MAGIC_CANDLE.get(), (Block)Registry.MAGIC_CANDLESTICK.get()});
        this.tag(Registry.PLANTER_PLANTS).add((Object[])new Block[]{(Block)Registry.MERAMMER_ROOT.get(), (Block)Registry.OANNA_BLOOM.get(), (Block)Registry.AVENNIAN_SPRIG.get(), (Block)Registry.SILDRIAN_SEED.get(), (Block)Registry.MIRECAP.get()});
    }

    void logsTag(Block ... blocks) {
        this.tag(BlockTags.LOGS).add((Object[])blocks);
        this.tag(BlockTags.LOGS_THAT_BURN).add((Object[])blocks);
        this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object[])blocks);
    }

    void addPickMineable(int level, Block ... blocks) {
        block6: for (Block block : blocks) {
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)block);
            switch (level) {
                case 1: {
                    this.tag(BlockTags.NEEDS_STONE_TOOL).add((Object)block);
                    continue block6;
                }
                case 2: {
                    this.tag(BlockTags.NEEDS_IRON_TOOL).add((Object)block);
                    continue block6;
                }
                case 3: {
                    this.tag(BlockTags.NEEDS_DIAMOND_TOOL).add((Object)block);
                    continue block6;
                }
                case 4: {
                    this.tag(Tags.Blocks.NEEDS_NETHERITE_TOOL).add((Object)block);
                }
            }
        }
    }

    @NotNull
    public String getName() {
        return "Eidolon Block Tags";
    }
}

