/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.api.spells;

import alexthw.eidolon_repraised.registries.Signs;
import alexthw.eidolon_repraised.util.ColorUtil;
import alexthw.eidolon_repraised.util.RGBProvider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record Sign(ResourceLocation key, ResourceLocation sprite, int color) implements RGBProvider
{
    public static Codec<Sign> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("sign").forGetter(Sign::getRegistryName)).apply((Applicative)instance, Signs::find));
    public static StreamCodec<RegistryFriendlyByteBuf, Sign> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, Sign::key, Signs::find);

    public ResourceLocation getRegistryName() {
        return this.key;
    }

    @Override
    public float getRed() {
        return (float)ColorUtil.getRed(this.color) / 255.0f;
    }

    @Override
    public float getGreen() {
        return (float)ColorUtil.getGreen(this.color) / 255.0f;
    }

    @Override
    public float getBlue() {
        return (float)ColorUtil.getBlue(this.color) / 255.0f;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Sign && ((Sign)other).key.equals((Object)this.key);
    }

    @Override
    public int hashCode() {
        return this.key.hashCode();
    }
}

