package alexthw.eidolon_repraised.common.tile;
// Made with Blockbench 4.1.3
// Exported for Minecraft version 1.17 with Mojang mappings
// Paste this class into your mod and generate all required imports

import alexthw.eidolon_repraised.Eidolon;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.*;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class CabinetModel extends EntityModel<Entity> {
	// This layer location should be baked with EntityRendererProvider.Context in the entity renderer and passed into this model's constructor
	public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath(Eidolon.MODID,"cabinet" ), "main");
	private final ModelPart left_door;
	private final ModelPart right_door;

	public CabinetModel(ModelPart root) {
		this.left_door = root.getChild("left_door");
		this.right_door = root.getChild("right_door");
	}

	public static LayerDefinition createBodyLayer() {
		MeshDefinition meshdefinition = new MeshDefinition();
		PartDefinition partdefinition = meshdefinition.getRoot();

		PartDefinition left_door = partdefinition.addOrReplaceChild("left_door", CubeListBuilder.create().texOffs(0, 0).addBox(0.0F, -12.0F, -2.0F, 5.0F, 22.0F, 2.0F, new CubeDeformation(0.0F)), PartPose.offset(-5.0F, 8.0F, -5.0F));

		PartDefinition right_door = partdefinition.addOrReplaceChild("right_door", CubeListBuilder.create().texOffs(14, 0).addBox(-5.0F, -12.0F, -2.0F, 5.0F, 22.0F, 2.0F, new CubeDeformation(0.0F)), PartPose.offset(5.0F, 8.0F, -5.0F));

		return LayerDefinition.create(meshdefinition, 32, 32);
	}

    @Override
    public void setupAnim(@NotNull Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {

    }

    @Override
    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        left_door.render(poseStack, buffer, packedLight, packedOverlay);
        right_door.render(poseStack, buffer, packedLight, packedOverlay);
    }

}