/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.item;

import alexthw.eidolon_repraised.common.item.Tiers;
import alexthw.eidolon_repraised.network.DeathbringerSlashEffectPacket;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.registries.EidolonPotions;
import alexthw.eidolon_repraised.util.ColorUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;

public class DeathbringerScytheItem
extends SwordItem {
    String loreTag = null;

    public DeathbringerScytheItem(Item.Properties builderIn) {
        super((Tier)Tiers.NecroticTier.INSTANCE, builderIn.attributes(SwordItem.createAttributes((Tier)Tiers.NecroticTier.INSTANCE, (int)7, (float)-2.9f)));
    }

    public Item setLore(String tag) {
        this.loreTag = tag;
        return this;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (this.loreTag != null) {
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.DARK_PURPLE) + String.valueOf(ChatFormatting.ITALIC) + I18n.get((String)this.loreTag, (Object[])new Object[0]))));
        }
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility action) {
        if (action == ItemAbilities.SWORD_SWEEP) {
            return false;
        }
        return super.canPerformAction(stack, action);
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, LivingEntity target, @NotNull LivingEntity attacker) {
        if (target.getType().is(EntityTypeTags.UNDEAD)) {
            target.addEffect(new MobEffectInstance(EidolonPotions.UNDEATH_EFFECT, 900));
        }
        if (!attacker.level().isClientSide) {
            Networking.sendToNearbyClient(attacker.level(), attacker.blockPosition(), (CustomPacketPayload)new DeathbringerSlashEffectPacket((float)attacker.getX(), (float)(attacker.getY() + (double)(target.getBbHeight() / 2.0f)), (float)attacker.getZ(), (float)target.getX(), (float)(target.getY() + (double)(target.getBbHeight() / 2.0f)), (float)target.getZ(), ColorUtil.packColor(255, 33, 26, 23), ColorUtil.packColor(255, 10, 10, 11), ColorUtil.packColor(255, 161, 255, 123), ColorUtil.packColor(255, 194, 171, 70)));
        }
        return super.hurtEnemy(stack, target, attacker);
    }
}

