/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.client.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SlashParticleData
implements ParticleOptions {
    float r1 = 1.0f;
    float g1 = 1.0f;
    float b1 = 1.0f;
    float a1 = 1.0f;
    float r2 = 1.0f;
    float g2 = 1.0f;
    float b2 = 1.0f;
    float a2 = 0.0f;
    float width = 0.625f;
    float rad = 1.0f;
    float pitch = 0.0f;
    float yaw = 0.0f;
    float roll = 0.0f;
    float angle = 0.0f;
    int lifetime = 10;
    float highlight = 0.0f;
    final ParticleType<?> type;

    public static MapCodec<SlashParticleData> codecFor(ParticleType<?> type) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("r1").forGetter(d -> Float.valueOf(d.r1)), (App)Codec.FLOAT.fieldOf("g1").forGetter(d -> Float.valueOf(d.g1)), (App)Codec.FLOAT.fieldOf("b1").forGetter(d -> Float.valueOf(d.b1)), (App)Codec.FLOAT.fieldOf("a1").forGetter(d -> Float.valueOf(d.a1)), (App)Codec.FLOAT.fieldOf("r2").forGetter(d -> Float.valueOf(d.r2)), (App)Codec.FLOAT.fieldOf("g2").forGetter(d -> Float.valueOf(d.g2)), (App)Codec.FLOAT.fieldOf("b2").forGetter(d -> Float.valueOf(d.b2)), (App)Codec.FLOAT.fieldOf("a2").forGetter(d -> Float.valueOf(d.a2)), (App)Codec.FLOAT.fieldOf("width").forGetter(d -> Float.valueOf(d.width)), (App)Codec.FLOAT.fieldOf("rad").forGetter(d -> Float.valueOf(d.rad)), (App)Codec.FLOAT.fieldOf("pitch").forGetter(d -> Float.valueOf(d.pitch)), (App)Codec.FLOAT.fieldOf("yaw").forGetter(d -> Float.valueOf(d.yaw)), (App)Codec.FLOAT.fieldOf("roll").forGetter(d -> Float.valueOf(d.roll)), (App)Codec.FLOAT.fieldOf("angle").forGetter(d -> Float.valueOf(d.angle)), (App)Codec.INT.fieldOf("lifetime").forGetter(d -> d.lifetime), (App)Codec.FLOAT.fieldOf("highlight").forGetter(d -> Float.valueOf(d.highlight))).apply((Applicative)instance, (r1, g1, b1, a1, r2, g2, b2, a2, width, rad, pitch, yaw, roll, angle, lifetime, highlight) -> {
            SlashParticleData data = new SlashParticleData(type);
            data.r1 = r1.floatValue();
            data.g1 = g1.floatValue();
            data.b1 = b1.floatValue();
            data.a1 = a1.floatValue();
            data.r2 = r2.floatValue();
            data.g2 = g2.floatValue();
            data.b2 = b2.floatValue();
            data.a2 = a2.floatValue();
            data.width = width.floatValue();
            data.rad = rad.floatValue();
            data.pitch = pitch.floatValue();
            data.yaw = yaw.floatValue();
            data.roll = roll.floatValue();
            data.angle = angle.floatValue();
            data.lifetime = lifetime;
            data.highlight = highlight.floatValue();
            return data;
        }));
    }

    public SlashParticleData(ParticleType<?> type) {
        this.type = type;
    }

    @NotNull
    public static StreamCodec<? super RegistryFriendlyByteBuf, SlashParticleData> streamCodecFor(ParticleType<? extends SlashParticleData> slashParticleType) {
        return StreamCodec.of(SlashParticleData::writeToNetwork, buf -> {
            float r1 = buf.readFloat();
            float g1 = buf.readFloat();
            float b1 = buf.readFloat();
            float a1 = buf.readFloat();
            float r2 = buf.readFloat();
            float g2 = buf.readFloat();
            float b2 = buf.readFloat();
            float a2 = buf.readFloat();
            float width = buf.readFloat();
            float rad = buf.readFloat();
            float pitch = buf.readFloat();
            float yaw = buf.readFloat();
            float roll = buf.readFloat();
            float angle = buf.readFloat();
            int lifetime = buf.readInt();
            float highlight = buf.readFloat();
            SlashParticleData data = new SlashParticleData(slashParticleType);
            data.r1 = r1;
            data.g1 = g1;
            data.b1 = b1;
            data.a1 = a1;
            data.r2 = r2;
            data.g2 = g2;
            data.b2 = b2;
            data.a2 = a2;
            data.width = width;
            data.rad = rad;
            data.pitch = pitch;
            data.yaw = yaw;
            data.roll = roll;
            data.angle = angle;
            data.lifetime = lifetime;
            data.highlight = highlight;
            return data;
        });
    }

    @NotNull
    public ParticleType<?> getType() {
        return this.type;
    }

    public static void writeToNetwork(FriendlyByteBuf buffer, SlashParticleData data) {
        buffer.writeFloat(data.r1).writeFloat(data.g1).writeFloat(data.b1).writeFloat(data.a1);
        buffer.writeFloat(data.r2).writeFloat(data.g2).writeFloat(data.b2).writeFloat(data.a2);
        buffer.writeFloat(data.width).writeFloat(data.rad);
        buffer.writeFloat(data.pitch).writeFloat(data.yaw).writeFloat(data.roll).writeFloat(data.angle);
        buffer.writeInt(data.lifetime);
    }

    public static SlashParticleData create(ParticleType<?> type) {
        return new SlashParticleData(type);
    }

    public SlashParticleData color(float r, float g, float b) {
        return this.color(r, g, b, this.a1, r, g, b, this.a2);
    }

    public SlashParticleData color(float r, float g, float b, float a) {
        return this.color(r, g, b, a, r, g, b, a);
    }

    public SlashParticleData color(float r1, float g1, float b1, float r2, float g2, float b2) {
        return this.color(r1, g1, b1, this.a1, r2, g2, b2, this.a2);
    }

    public SlashParticleData color(float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
        this.r1 = r1;
        this.g1 = g1;
        this.b1 = b1;
        this.a1 = a1;
        this.r2 = r2;
        this.g2 = g2;
        this.b2 = b2;
        this.a2 = a2;
        return this;
    }

    public SlashParticleData alpha(float a) {
        this.a1 = this.a2 = a;
        return this;
    }

    public SlashParticleData alpha(float a1, float a2) {
        this.a1 = a1;
        this.a2 = a2;
        return this;
    }

    public SlashParticleData width(float w) {
        this.width = w;
        return this;
    }

    public SlashParticleData lookat(double x1, double y1, double z1, double x2, double y2, double z2) {
        Vec3 horiz = new Vec3(x2 - x1, 0.0, z2 - z1);
        this.yaw = (float)Mth.atan2((double)(x2 - x1), (double)(z2 - z1));
        this.pitch = (float)Mth.atan2((double)(y2 - y1), (double)horiz.length());
        return this;
    }

    public SlashParticleData pitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public SlashParticleData yaw(float yaw) {
        this.yaw = yaw;
        return this;
    }

    public SlashParticleData roll(float roll) {
        this.roll = roll;
        return this;
    }

    public SlashParticleData highlight(float highlight) {
        this.highlight = highlight;
        return this;
    }

    public SlashParticleData angle(float angle) {
        this.angle = (float)Math.PI / 180 * angle;
        return this;
    }

    public SlashParticleData radius(float rad) {
        this.rad = rad;
        return this;
    }

    public SlashParticleData lifetime(int ticks) {
        this.lifetime = ticks;
        return this;
    }

    public void spawn(Level level, double x, double y, double z, double vx, double vy, double vz) {
        level.addParticle((ParticleOptions)this, x, y, z, vx, vy, vz);
    }
}

