/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.network;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.capability.WingsDataImpl;
import alexthw.eidolon_repraised.network.AbstractPacket;
import alexthw.eidolon_repraised.network.FeatherEffectPacket;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WingsFlapPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<WingsFlapPacket> TYPE = new CustomPacketPayload.Type(Eidolon.prefix("wings_flap"));
    public static final StreamCodec<RegistryFriendlyByteBuf, WingsFlapPacket> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, pkt -> pkt.uuid, WingsFlapPacket::new);
    final UUID uuid;

    public WingsFlapPacket(Player player) {
        this.uuid = player.getUUID();
    }

    public WingsFlapPacket(UUID uuid) {
        this.uuid = uuid;
    }

    public static void encode(WingsFlapPacket object, FriendlyByteBuf buffer) {
        buffer.writeUUID(object.uuid);
    }

    public static WingsFlapPacket decode(FriendlyByteBuf buffer) {
        return new WingsFlapPacket(buffer.readUUID());
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        Level world = player.level();
        Player targetPlayer = world.getPlayerByUUID(this.uuid);
        if (targetPlayer != null) {
            WingsDataImpl wings = (WingsDataImpl)targetPlayer.getCapability(EidolonCapabilities.WINGS_CAPABILITY);
            if (wings != null) {
                wings.tryFlapWings((Player)player);
            }
            Networking.sendToNearbyClient(world, targetPlayer.getOnPos(), (CustomPacketPayload)new FeatherEffectPacket(targetPlayer.getOnPos()));
        }
    }

    @NotNull
    public CustomPacketPayload.Type<WingsFlapPacket> type() {
        return TYPE;
    }
}

