/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.entity.ai;

import alexthw.eidolon_repraised.event.Events;
import alexthw.eidolon_repraised.util.EntityUtil;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.level.Level;

public class ThrallTargetGoal
extends TargetGoal {
    protected LivingEntity owner;

    public ThrallTargetGoal(PathfinderMob pMob) {
        super((Mob)pMob, true);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        return EntityUtil.isEnthralled((LivingEntity)this.mob);
    }

    public void start() {
        super.start();
        UUID master = this.mob.getPersistentData().getUUID("eidolon_repraised:thrall");
        this.owner = this.mob.level().getPlayerByUUID(master);
        if (this.owner == null) {
            ServerLevel server;
            Level level = this.mob.level();
            if (level instanceof ServerLevel && (level = (server = (ServerLevel)level).getEntity(master)) instanceof LivingEntity) {
                LivingEntity living;
                this.owner = living = (LivingEntity)level;
            } else {
                return;
            }
        }
        this.targetMob = Events.handleEnthralledTargeting(this.owner.getLastHurtByMob(), this.owner.getLastHurtMob(), (LivingEntity)this.mob);
    }

    public boolean canContinueToUse() {
        return this.canUse() && this.owner != null && this.targetMob != null && this.targetMob.isAlive() && this.mob.canAttack(this.targetMob);
    }
}

