/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.entity;

import alexthw.eidolon_repraised.util.EntityUtil;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class SpellProjectileEntity
extends Projectile {
    public static final TagKey<EntityType<?>> TRACKABLE = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"trackable"));
    public static final TagKey<EntityType<?>> TRACKABLE_BLACKLIST = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"trackable_blacklist"));
    public Predicate<Entity> trackingPredicate = this::shouldTrack;
    public Predicate<Entity> compulsoryTrackingPredicate = this::mustTrack;
    public boolean isTracking;
    public boolean noImmunityFrame;
    private final Predicate<Entity> impactPredicate = this::shouldImpact;

    public SpellProjectileEntity(EntityType<? extends Projectile> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public Entity shoot(double x, double y, double z, double vx, double vy, double vz, Entity caster, ItemStack stack) {
        this.setPos(x, y, z);
        this.setDeltaMovement(vx, vy, vz);
        this.setOwner(caster);
        this.hurtMarked = true;
        return this;
    }

    private boolean shouldImpact(Entity target) {
        if (!target.isSpectator() && target.isPickable() && !target.getUUID().equals(this.getOwnerUUID())) {
            return true;
        }
        return this.shouldTrack(target) && this.mustTrack(target);
    }

    private boolean shouldTrack(Entity target) {
        return !target.isSpectator() && !target.getUUID().equals(this.getOwnerUUID()) && !target.getType().is(TRACKABLE_BLACKLIST);
    }

    private boolean mustTrack(Entity target) {
        return target instanceof Enemy || target.getType().is(TRACKABLE);
    }

    public void tick() {
        if (this.isTracking) {
            EntityUtil.moveTowardsTarget((Entity)this);
        }
        Vec3 motion = this.getDeltaMovement();
        this.setDeltaMovement(motion.x * 0.96, (motion.y > 0.0 ? motion.y * 0.96 : motion.y) - (double)0.03f, motion.z * 0.96);
        super.tick();
        if (!this.level().isClientSide) {
            HitResult ray = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this.impactPredicate);
            if (ray.getType() == HitResult.Type.ENTITY) {
                this.onImpact(ray, ((EntityHitResult)ray).getEntity());
            } else if (ray.getType() == HitResult.Type.BLOCK) {
                this.onImpact(ray);
            }
        }
        Vec3 pos = this.position();
        this.xo = pos.x;
        this.yo = pos.y;
        this.zo = pos.z;
        this.setPos(pos.x + motion.x, pos.y + motion.y, pos.z + motion.z);
    }

    public UUID getOwnerUUID() {
        Entity owner = this.getOwner();
        return owner != null ? owner.getUUID() : null;
    }

    protected abstract void onImpact(HitResult var1, Entity var2);

    protected abstract void onImpact(HitResult var1);

    protected void handleSpellDamage(Entity caster, Entity target, DamageSource damageSource, float rawDamage) {
        int prevHurtResist = target.invulnerableTime;
        if (this.noImmunityFrame) {
            target.invulnerableTime = 0;
        }
        target.hurt(damageSource, rawDamage);
        if (this.noImmunityFrame) {
            target.invulnerableTime = prevHurtResist;
        }
    }
}

