/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.codex;

import alexthw.eidolon_repraised.codex.CodexGui;
import alexthw.eidolon_repraised.codex.Page;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class EntityPage
extends Page {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/gui/codex_entity_page.png");
    final EntityType<?> type;

    public <T extends Entity> EntityPage(EntityType<T> type) {
        super(BACKGROUND);
        this.type = type;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, @NotNull GuiGraphics guiGraphics, ResourceLocation bg, int x, int y, int mouseX, int mouseY) {
        Entity e = this.type.create((Level)Minecraft.getInstance().level);
        if (e == null) {
            return;
        }
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(e);
        Tesselator tess = Tesselator.getInstance();
        PoseStack mStack = guiGraphics.pose();
        mStack.pushPose();
        mStack.translate((float)(x + 64), (float)(y + 136), 64.0f);
        mStack.mulPose(Axis.XP.rotationDegrees(-15.0f));
        mStack.mulPose(Axis.YP.rotationDegrees(-30.0f));
        float scale = 112.0f / e.getBbHeight();
        scale = Math.min(scale, 100.0f);
        mStack.scale(scale, -scale, scale);
        MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
        Lighting.setupForFlatItems();
        renderer.render(e, e.getYRot(), 0.0f, mStack, (MultiBufferSource)buf, 0xF000F0);
        buf.endLastBatch();
        Lighting.setupFor3DItems();
        mStack.popPose();
    }
}

