/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.client.renderer;

import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.api.spells.SignSequence;
import alexthw.eidolon_repraised.common.entity.ChantCasterEntity;
import alexthw.eidolon_repraised.event.ClientEvents;
import alexthw.eidolon_repraised.util.RenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ChantCasterRenderer
extends EntityRenderer<ChantCasterEntity> {
    public ChantCasterRenderer(EntityRendererProvider.Context erm) {
        super(erm);
    }

    public void render(ChantCasterEntity entity, float yaw, float pticks, PoseStack mStack, @NotNull MultiBufferSource mb, int lmap) {
        mStack.pushPose();
        VertexConsumer b = ClientEvents.getDelayedRender().getBuffer(RenderUtil.GLOWING_SPRITE);
        VertexConsumer sb = ClientEvents.getDelayedRender().getBuffer(RenderUtil.GLOWING_BLOCK_PARTICLE);
        Minecraft mc = Minecraft.getInstance();
        double ex = Mth.lerp((double)pticks, (double)entity.xOld, (double)entity.getX());
        double ey = Mth.lerp((double)pticks, (double)entity.yOld, (double)entity.getY());
        double ez = Mth.lerp((double)pticks, (double)entity.zOld, (double)entity.getZ());
        double px = Mth.lerp((double)pticks, (double)mc.player.xOld, (double)mc.player.getX());
        double py = Mth.lerp((double)pticks, (double)mc.player.yOld, (double)mc.player.getY());
        double pz = Mth.lerp((double)pticks, (double)mc.player.zOld, (double)mc.player.getZ());
        TextureAtlasSprite beam = (TextureAtlasSprite)mc.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"particle/beam"));
        TextureAtlasSprite ring = (TextureAtlasSprite)mc.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"particle/ring"));
        Vec3 look = entity.look;
        yaw = (float)Mth.atan2((double)look.x, (double)look.z);
        Vec3 left = new Vec3(Math.cos(yaw), 0.0, -Math.sin(yaw));
        Vec3 up = left.cross(look);
        SignSequence spell = SignSequence.deserializeNbt((CompoundTag)entity.getEntityData().get(ChantCasterEntity.SIGNS));
        int i = 0;
        int sz = Math.max(0, spell.seq.size() - 1);
        float r = Mth.sqrt((float)sz) / 4.0f;
        if (sz > 0) {
            r = Math.max(0.3f, r);
        }
        Vec3 center = look.add(0.0, 0.5, 0.0);
        int nreps = entity.deathTimer > 0 && (Boolean)entity.getEntityData().get(ChantCasterEntity.SUCCEEDED) != false ? 3 : 1;
        float alphaMod = 1.0f;
        if (entity.deathTimer > 0) {
            alphaMod = (float)entity.deathTimer / 20.0f;
            alphaMod *= alphaMod;
            if (!((Boolean)entity.getEntityData().get(ChantCasterEntity.SUCCEEDED)).booleanValue()) {
                alphaMod *= alphaMod;
                center = center.add(look.scale((double)(1.0f - alphaMod)));
                r += 0.25f - 0.25f * alphaMod;
            }
        }
        for (int k = 0; k < nreps; ++k) {
            for (Sign s : spell.seq) {
                float a = -1.5707964f - (float)(i * 2) * (float)Math.PI / (float)spell.seq.size();
                float sa = Mth.sin((float)a);
                float ca = Mth.cos((float)a);
                Vec3 od = center.add(left.scale((double)(r * ca))).add(up.scale((double)(r * sa)));
                Vec3 dxd = left.scale(0.175);
                Vec3 dyd = up.scale(0.175);
                Vector3f o = new Vector3f((float)od.x, (float)od.y, (float)od.z);
                Vector3f dx = new Vector3f((float)dxd.x, (float)dxd.y, (float)dxd.z);
                Vector3f dy = new Vector3f((float)dyd.x, (float)dyd.y, (float)dyd.z);
                TextureAtlasSprite spr = (TextureAtlasSprite)mc.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(s.sprite());
                float brightMod = Mth.clamp((float)Mth.sin((float)(a + (float)Math.PI * 2 * (float)entity.tickCount / 20.0f)), (float)0.0f, (float)1.0f);
                brightMod *= brightMod;
                brightMod = 0.6f + 0.4f * brightMod;
                for (int j = 0; j < 2; ++j) {
                    sb.addVertex(mStack.last().pose(), o.x() - dx.x() + dy.x(), o.y() - dx.y() + dy.y(), o.z() - dx.z() + dy.z()).setUv(spr.getU1(), spr.getV1()).setColor(s.getRed(), s.getGreen(), s.getBlue(), brightMod * alphaMod).setLight(0);
                    sb.addVertex(mStack.last().pose(), o.x() - dx.x() - dy.x(), o.y() - dx.y() - dy.y(), o.z() - dx.z() - dy.z()).setUv(spr.getU1(), spr.getV0()).setColor(s.getRed(), s.getGreen(), s.getBlue(), brightMod * alphaMod).setLight(0);
                    sb.addVertex(mStack.last().pose(), o.x() + dx.x() - dy.x(), o.y() + dx.y() - dy.y(), o.z() + dx.z() - dy.z()).setUv(spr.getU0(), spr.getV0()).setColor(s.getRed(), s.getGreen(), s.getBlue(), brightMod * alphaMod).setLight(0);
                    sb.addVertex(mStack.last().pose(), o.x() + dx.x() + dy.x(), o.y() + dx.y() + dy.y(), o.z() + dx.z() + dy.z()).setUv(spr.getU0(), spr.getV1()).setColor(s.getRed(), s.getGreen(), s.getBlue(), brightMod * alphaMod).setLight(0);
                    sb.addVertex(mStack.last().pose(), o.x() + dx.x() + dy.x(), o.y() + dx.y() + dy.y(), o.z() + dx.z() + dy.z()).setUv(spr.getU1(), spr.getV1()).setColor(s.getRed(), s.getGreen(), s.getBlue(), brightMod * alphaMod).setLight(0);
                    sb.addVertex(mStack.last().pose(), o.x() + dx.x() - dy.x(), o.y() + dx.y() - dy.y(), o.z() + dx.z() - dy.z()).setUv(spr.getU1(), spr.getV0()).setColor(s.getRed(), s.getGreen(), s.getBlue(), brightMod * alphaMod).setLight(0);
                    sb.addVertex(mStack.last().pose(), o.x() - dx.x() - dy.x(), o.y() - dx.y() - dy.y(), o.z() - dx.z() - dy.z()).setUv(spr.getU0(), spr.getV0()).setColor(s.getRed(), s.getGreen(), s.getBlue(), brightMod * alphaMod).setLight(0);
                    sb.addVertex(mStack.last().pose(), o.x() - dx.x() + dy.x(), o.y() - dx.y() + dy.y(), o.z() - dx.z() + dy.z()).setUv(spr.getU0(), spr.getV1()).setColor(s.getRed(), s.getGreen(), s.getBlue(), brightMod * alphaMod).setLight(0);
                }
                dx.mul(1.75f);
                dy.mul(1.75f);
                sb.addVertex(mStack.last().pose(), o.x() - dx.x() + dy.x(), o.y() - dx.y() + dy.y(), o.z() - dx.z() + dy.z()).setUv(ring.getU1(), ring.getV1()).setColor(s.getRed(), s.getGreen(), s.getBlue(), alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), o.x() - dx.x() - dy.x(), o.y() - dx.y() - dy.y(), o.z() - dx.z() - dy.z()).setUv(ring.getU1(), ring.getV0()).setColor(s.getRed(), s.getGreen(), s.getBlue(), alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), o.x() + dx.x() - dy.x(), o.y() + dx.y() - dy.y(), o.z() + dx.z() - dy.z()).setUv(ring.getU0(), ring.getV0()).setColor(s.getRed(), s.getGreen(), s.getBlue(), alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), o.x() + dx.x() + dy.x(), o.y() + dx.y() + dy.y(), o.z() + dx.z() + dy.z()).setUv(ring.getU0(), ring.getV1()).setColor(s.getRed(), s.getGreen(), s.getBlue(), alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), o.x() + dx.x() + dy.x(), o.y() + dx.y() + dy.y(), o.z() + dx.z() + dy.z()).setUv(ring.getU1(), ring.getV1()).setColor(s.getRed(), s.getGreen(), s.getBlue(), alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), o.x() + dx.x() - dy.x(), o.y() + dx.y() - dy.y(), o.z() + dx.z() - dy.z()).setUv(ring.getU1(), ring.getV0()).setColor(s.getRed(), s.getGreen(), s.getBlue(), alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), o.x() - dx.x() - dy.x(), o.y() - dx.y() - dy.y(), o.z() - dx.z() - dy.z()).setUv(ring.getU0(), ring.getV0()).setColor(s.getRed(), s.getGreen(), s.getBlue(), alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), o.x() - dx.x() + dy.x(), o.y() - dx.y() + dy.y(), o.z() - dx.z() + dy.z()).setUv(ring.getU0(), ring.getV1()).setColor(s.getRed(), s.getGreen(), s.getBlue(), alphaMod * 0.5f).setLight(0);
                ++i;
            }
            i = 0;
            if (spell.seq.isEmpty()) continue;
            Iterator<Sign> iter = spell.seq.iterator();
            Sign cur = null;
            Sign next = spell.seq.getLast();
            float rr = r + 0.1375f;
            float rr2 = rr + 0.2f;
            float rs = r - 0.3f;
            float rs2 = rs + 0.2f;
            int steps = Math.max(24, spell.seq.size() * 4);
            if (steps % spell.seq.size() != 0) {
                steps += spell.seq.size() - steps % spell.seq.size();
            }
            int periodicity = Math.max(4, steps / spell.seq.size());
            for (i = 0; i < steps; ++i) {
                if (i % periodicity == 0) {
                    cur = next;
                    next = iter.next();
                    if (!iter.hasNext()) {
                        iter = spell.seq.iterator();
                    }
                }
                float a1 = -1.5707964f - (float)(i - periodicity) * ((float)Math.PI * 2) / (float)steps;
                float a2 = -1.5707964f - (float)(i - periodicity + 1) * ((float)Math.PI * 2) / (float)steps;
                float sa1 = Mth.sin((float)a1);
                float ca1 = Mth.cos((float)a1);
                float sa2 = Mth.sin((float)a2);
                float ca2 = Mth.cos((float)a2);
                float r1 = Mth.lerp((float)((float)(i % periodicity) / (float)periodicity), (float)cur.getRed(), (float)next.getRed());
                float r2 = Mth.lerp((float)((float)(i % periodicity + 1) / (float)periodicity), (float)cur.getRed(), (float)next.getRed());
                float g1 = Mth.lerp((float)((float)(i % periodicity) / (float)periodicity), (float)cur.getGreen(), (float)next.getGreen());
                float g2 = Mth.lerp((float)((float)(i % periodicity + 1) / (float)periodicity), (float)cur.getGreen(), (float)next.getGreen());
                float b1 = Mth.lerp((float)((float)(i % periodicity) / (float)periodicity), (float)cur.getBlue(), (float)next.getBlue());
                float b2 = Mth.lerp((float)((float)(i % periodicity + 1) / (float)periodicity), (float)cur.getBlue(), (float)next.getBlue());
                Vec3 id1 = center.add(left.scale((double)(rr * ca1))).add(up.scale((double)(rr * sa1)));
                Vec3 id2 = center.add(left.scale((double)(rr * ca2))).add(up.scale((double)(rr * sa2)));
                Vec3 od1 = center.add(left.scale((double)(rr2 * ca1))).add(up.scale((double)(rr2 * sa1)));
                Vec3 od2 = center.add(left.scale((double)(rr2 * ca2))).add(up.scale((double)(rr2 * sa2)));
                Vector3f i1 = new Vector3f((float)id1.x, (float)id1.y, (float)id1.z);
                Vector3f i2 = new Vector3f((float)id2.x, (float)id2.y, (float)id2.z);
                Vector3f o1 = new Vector3f((float)od1.x, (float)od1.y, (float)od1.z);
                Vector3f o2 = new Vector3f((float)od2.x, (float)od2.y, (float)od2.z);
                sb.addVertex(mStack.last().pose(), o1.x(), o1.y(), o1.z()).setUv(beam.getU1(), beam.getV1()).setColor(r1, g1, b1, alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), o2.x(), o2.y(), o2.z()).setUv(beam.getU0(), beam.getV1()).setColor(r2, g2, b2, alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), i2.x(), i2.y(), i2.z()).setUv(beam.getU0(), beam.getV0()).setColor(r2, g2, b2, alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), i1.x(), i1.y(), i1.z()).setUv(beam.getU1(), beam.getV0()).setColor(r1, g1, b1, alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), o2.x(), o2.y(), o2.z()).setUv(beam.getU1(), beam.getV1()).setColor(r2, g2, b2, alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), o1.x(), o1.y(), o1.z()).setUv(beam.getU0(), beam.getV1()).setColor(r1, g1, b1, alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), i1.x(), i1.y(), i1.z()).setUv(beam.getU0(), beam.getV0()).setColor(r1, g1, b1, alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), i2.x(), i2.y(), i2.z()).setUv(beam.getU1(), beam.getV0()).setColor(r2, g2, b2, alphaMod * 0.5f).setLight(0);
                id1 = center.add(left.scale((double)(rs * ca1))).add(up.scale((double)(rs * sa1)));
                id2 = center.add(left.scale((double)(rs * ca2))).add(up.scale((double)(rs * sa2)));
                od1 = center.add(left.scale((double)(rs2 * ca1))).add(up.scale((double)(rs2 * sa1)));
                od2 = center.add(left.scale((double)(rs2 * ca2))).add(up.scale((double)(rs2 * sa2)));
                i1 = new Vector3f((float)id1.x, (float)id1.y, (float)id1.z);
                i2 = new Vector3f((float)id2.x, (float)id2.y, (float)id2.z);
                o1 = new Vector3f((float)od1.x, (float)od1.y, (float)od1.z);
                o2 = new Vector3f((float)od2.x, (float)od2.y, (float)od2.z);
                sb.addVertex(mStack.last().pose(), o1.x(), o1.y(), o1.z()).setUv(beam.getU1(), beam.getV1()).setColor(r1, g1, b1, alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), o2.x(), o2.y(), o2.z()).setUv(beam.getU0(), beam.getV1()).setColor(r2, g2, b2, alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), i2.x(), i2.y(), i2.z()).setUv(beam.getU0(), beam.getV0()).setColor(r2, g2, b2, alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), i1.x(), i1.y(), i1.z()).setUv(beam.getU1(), beam.getV0()).setColor(r1, g1, b1, alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), o2.x(), o2.y(), o2.z()).setUv(beam.getU1(), beam.getV1()).setColor(r2, g2, b2, alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), o1.x(), o1.y(), o1.z()).setUv(beam.getU0(), beam.getV1()).setColor(r1, g1, b1, alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), i1.x(), i1.y(), i1.z()).setUv(beam.getU0(), beam.getV0()).setColor(r1, g1, b1, alphaMod * 0.5f).setLight(0);
                sb.addVertex(mStack.last().pose(), i2.x(), i2.y(), i2.z()).setUv(beam.getU1(), beam.getV0()).setColor(r2, g2, b2, alphaMod * 0.5f).setLight(0);
            }
        }
        mStack.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ChantCasterEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/particle/beam.png");
    }
}

