/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.network;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.capability.SoulImpl;
import alexthw.eidolon_repraised.network.AbstractPacket;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SoulUpdatePacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<SoulUpdatePacket> TYPE = new CustomPacketPayload.Type(Eidolon.prefix("soul_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SoulUpdatePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, pkt -> pkt.isPlayer, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), pkt -> pkt.isPlayer ? Optional.of(pkt.uuid) : Optional.empty(), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), pkt -> pkt.isPlayer ? Optional.empty() : Optional.of(pkt.id), (StreamCodec)ByteBufCodecs.COMPOUND_TAG, pkt -> pkt.tag, (isPlayer, uuidOpt, idOpt, tag) -> isPlayer != false ? new SoulUpdatePacket((UUID)uuidOpt.orElseThrow(), (CompoundTag)tag) : new SoulUpdatePacket((Integer)idOpt.orElseThrow(), (CompoundTag)tag));
    final boolean isPlayer;
    UUID uuid;
    int id;
    CompoundTag tag;

    public SoulUpdatePacket(int id, CompoundTag tag) {
        this.isPlayer = false;
        this.id = id;
        this.tag = tag;
    }

    public SoulUpdatePacket(UUID uuid, CompoundTag tag) {
        this.isPlayer = true;
        this.uuid = uuid;
        this.tag = tag;
    }

    public SoulUpdatePacket(LivingEntity entity) {
        this.isPlayer = entity instanceof Player;
        if (this.isPlayer) {
            this.uuid = entity.getUUID();
        } else {
            this.id = entity.getId();
        }
        this.tag = ((SoulImpl)entity.getCapability(EidolonCapabilities.SOUL_HEART_CAPABILITY)).serializeNBT();
    }

    public SoulUpdatePacket(Player entity) {
        this.isPlayer = true;
        this.uuid = entity.getUUID();
        this.tag = ((SoulImpl)entity.getCapability(EidolonCapabilities.SOUL_HEART_CAPABILITY)).serializeNBT();
    }

    public static void encode(SoulUpdatePacket object, FriendlyByteBuf buffer) {
        buffer.writeBoolean(object.isPlayer);
        if (object.isPlayer) {
            buffer.writeUUID(object.uuid);
        } else {
            buffer.writeInt(object.id);
        }
        buffer.writeNbt((Tag)object.tag);
    }

    public static SoulUpdatePacket decode(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            return new SoulUpdatePacket(buffer.readUUID(), buffer.readNbt());
        }
        return new SoulUpdatePacket(buffer.readInt(), buffer.readNbt());
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        ((SoulImpl)player.getCapability(EidolonCapabilities.SOUL_HEART_CAPABILITY)).deserializeNBT(this.tag);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

