/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.network;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.client.particle.Particles;
import alexthw.eidolon_repraised.network.AbstractPacket;
import alexthw.eidolon_repraised.registries.EidolonParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RitualConsumePacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<RitualConsumePacket> TYPE = new CustomPacketPayload.Type(Eidolon.prefix("ritual_consume"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RitualConsumePacket> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, pkt -> pkt.src, (StreamCodec)BlockPos.STREAM_CODEC, pkt -> pkt.dst, (StreamCodec)ByteBufCodecs.FLOAT, pkt -> Float.valueOf(pkt.r), (StreamCodec)ByteBufCodecs.FLOAT, pkt -> Float.valueOf(pkt.g), (StreamCodec)ByteBufCodecs.FLOAT, pkt -> Float.valueOf(pkt.b), RitualConsumePacket::new);
    final BlockPos src;
    final BlockPos dst;
    final float r;
    final float g;
    final float b;

    public RitualConsumePacket(BlockPos src, BlockPos dst, float r, float g, float b) {
        this.src = src;
        this.dst = dst;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Level world = player.level();
        BlockPos src = this.src;
        BlockPos dst = this.dst;
        world.playSound(Eidolon.proxy.getPlayer(), (double)src.getX() + 0.5, (double)src.getY() + 0.5, (double)src.getZ() + 0.5, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
        for (int i = 0; i < 10; ++i) {
            Particles.create((ParticleType)EidolonParticles.LINE_WISP_PARTICLE.get()).setAlpha(0.75f, 0.0f).setScale(0.25f + 0.125f * world.random.nextFloat(), 0.0f).setLifetime(16 + world.random.nextInt(4)).randomOffset(0.375, 0.375).randomVelocity(0.125, 0.125).addVelocity((double)dst.getX() + 0.5, dst.getY() + 1, (double)dst.getZ() + 0.5).setColor(this.r, this.g, this.b, this.r, this.g * 0.5f, this.b * 1.5f).spawn(world, (double)src.getX() + 0.5, (double)src.getY() + 0.5, (double)src.getZ() + 0.5);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

