/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.gui;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.client.ClientRegistry;
import alexthw.eidolon_repraised.codex.CodexGui;
import alexthw.eidolon_repraised.gui.CancelButton;
import alexthw.eidolon_repraised.gui.ChantButton;
import alexthw.eidolon_repraised.gui.ScriptoriumContainer;
import alexthw.eidolon_repraised.gui.SignButton;
import alexthw.eidolon_repraised.network.InscribePacket;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.util.KnowledgeUtil;
import alexthw.eidolon_repraised.util.RenderUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;

public class ScriptoriumScreen
extends AbstractContainerScreen<ScriptoriumContainer> {
    public int FULL_WIDTH = 256;
    public int FULL_HEIGHT = 256;
    public static ResourceLocation background = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/gui/inscription_table.png");
    public List<Sign> currentChant;
    public List<SignButton> signButtons = new ArrayList<SignButton>();
    public int bookLeft;
    public int bookTop;
    public int bookRight;
    public int bookBottom;

    public ScriptoriumScreen(ScriptoriumContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    public void init() {
        super.init();
        this.bookLeft = this.width / 2 - this.FULL_WIDTH / 2;
        this.bookTop = this.height / 2 - this.FULL_HEIGHT / 2;
        this.bookRight = this.width / 2 + this.FULL_WIDTH / 2;
        this.bookBottom = this.height / 2 + this.FULL_HEIGHT / 2;
        this.currentChant = new ArrayList<Sign>(7);
        this.layoutSigns();
        this.addRenderableWidget((GuiEventListener)new ChantButton(this.bookLeft, this.bookTop + 8, 32, 32, b -> {
            if (!this.currentChant.isEmpty()) {
                Networking.sendToServer(new InscribePacket(((ScriptoriumContainer)this.menu).containerId, this.currentChant));
            }
        }));
        this.addRenderableWidget((GuiEventListener)new CancelButton(this.bookLeft, this.bookTop + 8 + 32, 32, 32, b -> this.currentChant.clear()));
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        this.drawScreenAfterScale(graphics, mouseX, mouseY, partialTicks);
        matrixStack.popPose();
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        graphics.blit(background, this.bookLeft + 32, this.bookTop, 0.0f, 0.0f, 200, this.FULL_HEIGHT, this.FULL_WIDTH, this.FULL_HEIGHT);
        graphics.blit(background, this.bookLeft - 2, this.bookTop + 72, 200.0f, 92.0f, 36, 56, this.FULL_WIDTH, this.FULL_HEIGHT);
    }

    public void drawBackgroundElements(GuiGraphics graphics) {
    }

    public void drawForegroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderChant(graphics, mouseX, mouseY, partialTicks);
    }

    public void drawScreenAfterScale(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)this.bookLeft, (float)this.bookTop, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundElements(graphics);
        this.drawForegroundElements(graphics, mouseX, mouseY, partialTicks);
        poseStack.popPose();
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    public void layoutSigns() {
        this.signButtons = new ArrayList<SignButton>();
        List<Sign> signs = KnowledgeUtil.getKnownSigns(Eidolon.proxy.getPlayer());
        int startX = this.bookLeft + 24;
        int startY = this.bookTop - 15;
        for (int i = 0; i < signs.size(); ++i) {
            Sign sign = signs.get(i);
            SignButton button = new SignButton(startX + 8 + i % 5 * 38, startY + 16 + i / 5 * 40, 30, 30, sign, b -> {
                if (this.currentChant.size() < 7) {
                    this.currentChant.add(sign);
                }
            });
            this.signButtons.add(button);
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    protected void renderChant(@NotNull GuiGraphics mStack, int mouseX, int mouseY, float pticks) {
        List<Sign> chant = this.currentChant;
        int chantWidth = 32 + 24 * chant.size();
        int baseX = 132 - chantWidth / 2;
        int y = 125;
        RenderSystem.enableBlend();
        int bgx = baseX;
        CodexGui.blit(mStack, bgx, y, 256.0f, 208.0f, 16, 32, 512, 512);
        bgx += 16;
        for (int i = 0; i < chant.size(); ++i) {
            CodexGui.blit(mStack, bgx, y, 272.0f, 208.0f, 24, 32, 512, 512);
            CodexGui.blit(mStack, bgx, y, 312.0f, 208.0f, 24, 24, 512, 512);
            bgx += 24;
        }
        CodexGui.blit(mStack, bgx, y, 296.0f, 208.0f, 16, 32, 512, 512);
        RenderSystem.enableBlend();
        RenderSystem.setShader(ClientRegistry::getGlowingSpriteShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        MultiBufferSource.BufferSource buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        bgx = baseX + 16;
        for (Sign sign : chant) {
            RenderUtil.litQuad(mStack.pose(), (MultiBufferSource)buffersource, bgx + 4, y + 4, 16.0, 16.0, sign.getRed(), sign.getGreen(), sign.getBlue(), (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(sign.sprite()));
            buffersource.endBatch();
            bgx += 24;
        }
        bgx = baseX + 16;
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        for (int i = 0; i < chant.size(); ++i) {
            float flicker = 0.75f + 0.05f * (float)Math.sin(Math.toRadians(12.0f * pticks - 360.0f * (float)i / (float)chant.size()));
            Sign sign = chant.get(i);
            RenderUtil.litQuad(mStack.pose(), (MultiBufferSource)buffersource, bgx + 4, y + 4, 16.0, 16.0, sign.getRed() * flicker, sign.getGreen() * flicker, sign.getBlue() * flicker, (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(sign.sprite()));
            buffersource.endBatch();
            bgx += 24;
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)background);
    }

    protected void renderTooltip(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        this.collectTooltips(mouseX, mouseY, tooltip);
        if (!tooltip.isEmpty()) {
            stack.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        }
        super.renderTooltip(stack, mouseX, mouseY);
    }

    private void collectTooltips(int mouseX, int mouseY, List<Component> tooltip) {
    }

    protected void renderLabels(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }
}

