/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.block;

import alexthw.eidolon_repraised.common.block.HorizontalBlockBase;
import alexthw.eidolon_repraised.common.tile.ResearchTableTileEntity;
import alexthw.eidolon_repraised.gui.ResearchTableContainer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class ResearchTableBlock
extends HorizontalBlockBase
implements EntityBlock {
    public ResearchTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (worldIn.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileentity = worldIn.getBlockEntity(pos);
        if (tileentity instanceof ResearchTableTileEntity) {
            ResearchTableTileEntity researchTable = (ResearchTableTileEntity)tileentity;
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inventory, p) -> new ResearchTableContainer(id, inventory, (Container)researchTable, researchTable.dataAccess), researchTable.getDisplayName()), pos);
        }
        return InteractionResult.CONSUME;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ResearchTableTileEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (level1, pos, state1, tile) -> ((ResearchTableTileEntity)tile).tick();
    }
}

