/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.registries;

import alexthw.eidolon_repraised.common.entity.GiantSkeletonEntity;
import alexthw.eidolon_repraised.common.entity.NecromancerEntity;
import alexthw.eidolon_repraised.common.entity.RavenEntity;
import alexthw.eidolon_repraised.common.entity.SlimySlugEntity;
import alexthw.eidolon_repraised.common.entity.WraithEntity;
import alexthw.eidolon_repraised.common.entity.ZombieBruteEntity;
import alexthw.eidolon_repraised.registries.EidolonEntities;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class EidolonAttributes {
    static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"eidolon_repraised");
    public static final DeferredHolder<Attribute, Attribute> CHANTING_SPEED = ATTRIBUTES.register("chanting_speed", () -> new RangedAttribute("eidolon_repraised.chanting_speed", 1.0, 0.0, 100.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> PERSISTENT_SOUL_HEARTS = ATTRIBUTES.register("persistent_soul_hearts", () -> new RangedAttribute("eidolon_repraised.persistent_soul_hearts", 0.0, 0.0, 2000.0).setSyncable(true));
    @Deprecated(forRemoval=true)
    public static final DeferredHolder<Attribute, Attribute> MAX_SOUL_HEARTS = ATTRIBUTES.register("max_soul_hearts", () -> new RangedAttribute("eidolon_repraised.max_soul_hearts", 60.0, 0.0, 2000.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> MAGIC_POWER = ATTRIBUTES.register("magic_power", () -> new RangedAttribute("attribute.eidolon_repraised.magic_power", 1.0, 0.0, 10.0).setSyncable(true));

    @SubscribeEvent
    public static void addCustomAttributes(EntityAttributeModificationEvent event) {
        for (EntityType t : event.getTypes()) {
            if (event.has(t, Attributes.MAX_HEALTH)) {
                event.add(t, PERSISTENT_SOUL_HEARTS);
                event.add(t, MAX_SOUL_HEARTS);
            }
            if (t != EntityType.PLAYER) continue;
            event.add(t, MAGIC_POWER);
            event.add(t, CHANTING_SPEED);
        }
    }

    @SubscribeEvent
    public static void defineAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)EidolonEntities.ZOMBIE_BRUTE.get(), ZombieBruteEntity.createAttributes());
        event.put((EntityType)EidolonEntities.WRAITH.get(), WraithEntity.createAttributes());
        event.put((EntityType)EidolonEntities.NECROMANCER.get(), NecromancerEntity.createAttributes());
        event.put((EntityType)EidolonEntities.RAVEN.get(), RavenEntity.createAttributes());
        event.put((EntityType)EidolonEntities.SLIMY_SLUG.get(), SlimySlugEntity.createAttributes());
        event.put((EntityType)EidolonEntities.GIANT_SKEL.get(), GiantSkeletonEntity.createAttributes().build());
    }
}

