/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.gui.jei;

import alexthw.eidolon_repraised.api.IDyeable;
import alexthw.eidolon_repraised.recipe.DyeRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class DyeRecipeCategory
implements ICraftingCategoryExtension<DyeRecipe> {
    private final DyeRecipe recipe;

    public DyeRecipeCategory(DyeRecipe recipe) {
        this.recipe = recipe;
    }

    public void setRecipe(@NotNull RecipeHolder holder, @NotNull IRecipeLayoutBuilder builder, @NotNull ICraftingGridHelper craftingGridHelper, @NotNull IFocusGroup focuses) {
        List<List> inputs = this.recipe.getIngredients().stream().map(ingredient -> List.of(ingredient.getItems())).toList();
        ItemStack resultItem = this.recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY);
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        Item item = resultItem.getItem();
        if (item instanceof IDyeable) {
            IDyeable toDye = (IDyeable)item;
            List<ItemStack> focus = focuses.getItemStackFocuses(RecipeIngredientRole.INPUT).map(f -> (ItemStack)f.getTypedValue().getIngredient()).filter(f -> f.getItem() instanceof DyeItem).toList();
            List<DyeColor> colors = focus.isEmpty() ? Arrays.stream(((Ingredient)this.recipe.getIngredients().getFirst()).getItems()).map(DyeColor::getColor).toList() : focus.stream().map(DyeColor::getColor).toList();
            for (DyeColor color : colors) {
                if (color == null) continue;
                ItemStack copy = resultItem.copy();
                toDye.onDye(copy, color);
                results.add(copy);
            }
        }
        craftingGridHelper.createAndSetOutputs(builder, results);
        craftingGridHelper.createAndSetInputs(builder, inputs, 0, 0);
    }
}

