/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.gui;

import alexthw.eidolon_repraised.gui.SoulEnchanterContainer;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public class SoulEnchanterScreen
extends AbstractContainerScreen<SoulEnchanterContainer> {
    private static final ResourceLocation ENCHANTMENT_TABLE_GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/gui/soul_enchanter.png");
    private static final ResourceLocation ENCHANTMENT_TABLE_BOOK_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/entity/enchanter_book.png");
    private static BookModel MODEL_BOOK = null;
    private final Random random = new Random();
    public int ticks;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    private ItemStack last = ItemStack.EMPTY;

    public SoulEnchanterScreen(SoulEnchanterContainer container, Inventory playerInventory, Component textComponent) {
        super((AbstractContainerMenu)container, playerInventory, textComponent);
        if (MODEL_BOOK == null) {
            MODEL_BOOK = new BookModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.BOOK));
        }
    }

    public void containerTick() {
        super.containerTick();
        this.tickBook();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        for (int k = 0; k < 3; ++k) {
            double d0 = mouseX - (double)(i + 60);
            double d1 = mouseY - (double)(j + 14 + 19 * k);
            if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 108.0) || !(d1 < 19.0) || !((SoulEnchanterContainer)this.menu).clickMenuButton((Player)this.minecraft.player, k)) continue;
            this.minecraft.gameMode.handleInventoryButtonClick(((SoulEnchanterContainer)this.menu).containerId, k);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(ENCHANTMENT_TABLE_GUI_TEXTURE, i, j, 0, 0, this.imageWidth, this.imageHeight);
        this.renderBook(pGuiGraphics, i, j, pPartialTick);
        EnchantmentNames.getInstance().initSeed((long)((SoulEnchanterContainer)this.menu).getXPSeed());
        int soulShardAmount = ((SoulEnchanterContainer)this.menu).getSoulShardAmount();
        for (int i1 = 0; i1 < 3; ++i1) {
            int j1 = i + 60;
            int k1 = j1 + 20;
            int experienceLevelCost = Math.min(10, ((SoulEnchanterContainer)this.menu).worldClue[i1]);
            int i2 = 86;
            FormattedText formattedtext = EnchantmentNames.getInstance().getRandomName(this.font, i2);
            int j2 = 6839882;
            if (experienceLevelCost < 1) {
                pGuiGraphics.blit(ENCHANTMENT_TABLE_GUI_TEXTURE, j1, j + 14 + 19 * i1, 0, 185, 108, 19);
                continue;
            }
            if ((soulShardAmount == 0 || this.minecraft.player.experienceLevel < experienceLevelCost) && !this.minecraft.player.getAbilities().instabuild || ((SoulEnchanterContainer)this.menu).enchantClue[i1] == -1) {
                pGuiGraphics.blit(ENCHANTMENT_TABLE_GUI_TEXTURE, j1, j + 14 + 19 * i1, 0, 185, 108, 19);
                pGuiGraphics.blit(ENCHANTMENT_TABLE_GUI_TEXTURE, j1 + 1, j + 15 + 19 * i1, 16 * (experienceLevelCost - 1), 239, 16, 16);
                pGuiGraphics.drawWordWrap(this.font, formattedtext, k1, j + 16 + 19 * i1, i2, (j2 & 0xFEFEFE) >> 1);
                j2 = 4226832;
                continue;
            }
            int k2 = pMouseX - (i + 60);
            int l2 = pMouseY - (j + 14 + 19 * i1);
            if (k2 >= 0 && l2 >= 0 && k2 < 108 && l2 < 19) {
                pGuiGraphics.blit(ENCHANTMENT_TABLE_GUI_TEXTURE, j1, j + 14 + 19 * i1, 0, 204, 108, 19);
                j2 = 0xFFFF80;
            } else {
                pGuiGraphics.blit(ENCHANTMENT_TABLE_GUI_TEXTURE, j1, j + 14 + 19 * i1, 0, 166, 108, 19);
            }
            pGuiGraphics.blit(ENCHANTMENT_TABLE_GUI_TEXTURE, j1 + 1, j + 15 + 19 * i1, 16 * (experienceLevelCost - 1), 223, 16, 16);
            pGuiGraphics.drawWordWrap(this.font, formattedtext, k1, j + 16 + 19 * i1, i2, j2);
            j2 = 8453920;
        }
    }

    private void renderBook(GuiGraphics pGuiGraphics, int pX, int pY, float pPartialTick) {
        float f = Mth.lerp((float)pPartialTick, (float)this.oOpen, (float)this.open);
        float f1 = Mth.lerp((float)pPartialTick, (float)this.oFlip, (float)this.flip);
        Lighting.setupForEntityInInventory();
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)pX + 33.0f, (float)pY + 31.0f, 100.0f);
        float f2 = 40.0f;
        pGuiGraphics.pose().scale(-40.0f, 40.0f, 40.0f);
        pGuiGraphics.pose().mulPose(Axis.XP.rotationDegrees(25.0f));
        pGuiGraphics.pose().translate((1.0f - f) * 0.2f, (1.0f - f) * 0.1f, (1.0f - f) * 0.25f);
        float f3 = -(1.0f - f) * 90.0f - 90.0f;
        pGuiGraphics.pose().mulPose(Axis.YP.rotationDegrees(f3));
        pGuiGraphics.pose().mulPose(Axis.XP.rotationDegrees(180.0f));
        float f4 = Mth.clamp((float)(Mth.frac((float)(f1 + 0.25f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        float f5 = Mth.clamp((float)(Mth.frac((float)(f1 + 0.75f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        MODEL_BOOK.setupAnim(0.0f, f4, f5, f);
        VertexConsumer vertexconsumer = pGuiGraphics.bufferSource().getBuffer(MODEL_BOOK.renderType(ENCHANTMENT_TABLE_BOOK_TEXTURE));
        MODEL_BOOK.renderToBuffer(pGuiGraphics.pose(), vertexconsumer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        pGuiGraphics.flush();
        pGuiGraphics.pose().popPose();
        Lighting.setupFor3DItems();
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pPartialTick = this.minecraft.getFrameTimeNs();
        this.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        boolean flag = this.minecraft.player.getAbilities().instabuild;
        int soulShardAmount = ((SoulEnchanterContainer)this.menu).getSoulShardAmount();
        for (int j = 0; j < 3; ++j) {
            Optional enchantment = this.minecraft.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(((SoulEnchanterContainer)this.menu).enchantClue[j]);
            int enchantmentLevel = ((SoulEnchanterContainer)this.menu).worldClue[j];
            int experienceLevelCost = Math.min(10, enchantmentLevel);
            int i1 = j + 1;
            if (!this.isHovering(60, 14 + 19 * j, 108, 17, pMouseX, pMouseY) || enchantmentLevel <= 0) continue;
            ArrayList list = Lists.newArrayList();
            list.add(Component.translatable((String)"container.enchant.clue", (Object[])new Object[]{enchantment.isEmpty() ? "" : Enchantment.getFullname((Holder)((Holder)enchantment.get()), (int)enchantmentLevel)}).withStyle(ChatFormatting.WHITE));
            list.add(Component.literal((String)""));
            list.add(Component.translatable((String)"neoforge.container.enchant.limitedEnchantability").withStyle(ChatFormatting.RED));
            pGuiGraphics.renderComponentTooltip(this.font, (List)list, pMouseX, pMouseY);
            break;
        }
    }

    public void tickBook() {
        ItemStack itemstack = ((SoulEnchanterContainer)this.menu).getSlot(0).getItem();
        if (!ItemStack.matches((ItemStack)itemstack, (ItemStack)this.last)) {
            this.last = itemstack;
            do {
                this.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (this.flip <= this.flipT + 1.0f && this.flip >= this.flipT - 1.0f);
        }
        ++this.ticks;
        this.oFlip = this.flip;
        this.oOpen = this.open;
        boolean flag = false;
        for (int i = 0; i < 3; ++i) {
            if (((SoulEnchanterContainer)this.menu).worldClue[i] == 0) continue;
            flag = true;
            break;
        }
        this.open = flag ? (this.open += 0.2f) : (this.open -= 0.2f);
        this.open = Mth.clamp((float)this.open, (float)0.0f, (float)1.0f);
        float f1 = (this.flipT - this.flip) * 0.4f;
        float f = 0.2f;
        f1 = Mth.clamp((float)f1, (float)-0.2f, (float)0.2f);
        this.flipA += (f1 - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }
}

