/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.gui;

import alexthw.eidolon_repraised.api.research.Research;
import alexthw.eidolon_repraised.api.research.ResearchTask;
import alexthw.eidolon_repraised.common.item.ResearchNotesItem;
import alexthw.eidolon_repraised.common.tile.ResearchTableTileEntity;
import alexthw.eidolon_repraised.mixin.AbstractContainerMenuMixin;
import alexthw.eidolon_repraised.registries.EidolonDataComponents;
import alexthw.eidolon_repraised.registries.Registry;
import alexthw.eidolon_repraised.registries.Researches;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ResearchTableContainer
extends AbstractContainerMenu
implements ContainerListener {
    private final Container tile;
    private final ContainerData intArray;
    protected final List<ResearchTask> tasks;

    public ResearchTableContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(2));
    }

    public ResearchTableContainer(int id, Inventory playerInventory, Container inventory, ContainerData data) {
        super((MenuType)Registry.RESEARCH_TABLE_CONTAINER.get(), id);
        this.tile = inventory;
        this.intArray = data;
        this.addSlot(new NotesSlot(inventory, 0, 58, 68));
        this.addSlot(new SealSlot(inventory, 1, 58, 32));
        this.addDataSlots(data);
        this.tasks = new ArrayList<ResearchTask>();
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInventory, i1 + k * 9 + 9, 16 + i1 * 18, 142 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInventory, l, 16 + l * 18, 200));
        }
        if (inventory instanceof ResearchTableTileEntity) {
            ResearchTableTileEntity t = (ResearchTableTileEntity)inventory;
            t.addListener(this);
        }
        if (this.tile instanceof ResearchTableTileEntity) {
            this.updateSlots();
        }
    }

    protected void popSlot() {
        this.slots.removeLast();
        NonNullList<ItemStack> lastSlots = ((AbstractContainerMenuMixin)((Object)this)).getLastSlots();
        NonNullList<ItemStack> remoteSlots = ((AbstractContainerMenuMixin)((Object)this)).getRemoteSlots();
        lastSlots.removeLast();
        remoteSlots.removeLast();
    }

    public void clicked(int pSlotId, int pButton, @NotNull ClickType pClickType, @NotNull Player pPlayer) {
        if (pSlotId >= this.slots.size()) {
            return;
        }
        super.clicked(pSlotId, pButton, pClickType, pPlayer);
    }

    public void updateSlots() {
        Container container = this.tile;
        if (container instanceof ResearchTableTileEntity) {
            ResearchTableTileEntity t = (ResearchTableTileEntity)container;
            for (int i = 38; i < this.slots.size(); ++i) {
                if (((Slot)this.slots.get(i)).getItem().isEmpty()) continue;
                double d0 = (float)t.getBlockPos().getY() + 1.3f;
                ItemEntity itementity = new ItemEntity(t.getLevel(), (double)t.getBlockPos().getX() + 0.5, d0, (double)t.getBlockPos().getZ() + 0.5, ((Slot)this.slots.get(i)).getItem());
                itementity.setPickUpDelay(40);
                t.getLevel().addFreshEntity((Entity)itementity);
            }
        }
        while (this.slots.size() > 38) {
            this.popSlot();
        }
        this.checkTask();
        if (this.tile instanceof ResearchTableTileEntity) {
            this.broadcastFullState();
        }
    }

    private void checkTask() {
        if (!((Slot)this.slots.getFirst()).getItem().is((Item)Registry.RESEARCH_NOTES.get()) || this.getProgress() > 0) {
            return;
        }
        ItemStack stack = ((Slot)this.slots.getFirst()).getItem();
        ResearchNotesItem.ResearchData tag = (ResearchNotesItem.ResearchData)stack.get(EidolonDataComponents.RESEARCH);
        if (tag == null || tag.research() == null) {
            return;
        }
        Research r = Researches.find(tag.research());
        if (r == null || tag.stepsDone() >= r.getStars()) {
            return;
        }
        List<ResearchTask> tasks = r.getTasks(this.getSeed(stack), tag.stepsDone());
        for (int i = 0; i < tasks.size(); ++i) {
            int x = 189;
            int y = 17 + 36 * i;
            tasks.get(i).modifyContainer(this, x, y);
        }
    }

    public void removed(@NotNull Player player) {
        Container container;
        super.removed(player);
        if (player instanceof ServerPlayer) {
            for (int i = 38; i < this.slots.size(); ++i) {
                if (((Slot)this.slots.get(i)).getItem().isEmpty()) continue;
                player.drop(((Slot)this.slots.get(i)).getItem(), false);
            }
        }
        if ((container = this.tile) instanceof ResearchTableTileEntity) {
            ResearchTableTileEntity t = (ResearchTableTileEntity)container;
            t.removeListener(this);
        }
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return this.tile.stillValid(playerIn);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 0 || index > 1 && index < 38) {
                boolean placeInExtraSlots = false;
                for (int extra = 38; extra < this.slots.size(); ++extra) {
                    placeInExtraSlots = placeInExtraSlots || ((Slot)this.slots.get(extra)).mayPlace(itemstack1);
                }
                if (placeInExtraSlots ? !this.moveItemStackTo(itemstack1, 38, this.slots.size(), false) : (((Slot)this.slots.get(0)).mayPlace(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (((Slot)this.slots.get(1)).mayPlace(itemstack1) ? !this.moveItemStackTo(itemstack1, 1, 2, false) : (index >= 2 && index < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : (index >= 29 ? !this.moveItemStackTo(itemstack1, 2, 29, false) : !this.moveItemStackTo(itemstack1, 2, 38, false)))))) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (!this.moveItemStackTo(itemstack1, 2, 38, false)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    public int getProgress() {
        return this.intArray.get(0);
    }

    public int getSeed(ItemStack stack) {
        ResearchNotesItem.ResearchData researchTag = (ResearchNotesItem.ResearchData)stack.get(EidolonDataComponents.RESEARCH);
        if (researchTag == null) {
            return 0;
        }
        return (int)researchTag.seed();
    }

    public void initializeContents(int id, List<ItemStack> items, @NotNull ItemStack carried) {
        ((Slot)this.slots.getFirst()).set(items.getFirst().copy());
        this.updateSlots();
        try {
            super.initializeContents(id, items, carried);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public void trySubmitGoal(Player player, int index) {
        if (((Slot)this.slots.getFirst()).getItem().is((Item)Registry.RESEARCH_NOTES.get())) {
            ItemStack stack = ((Slot)this.slots.getFirst()).getItem();
            ResearchNotesItem.ResearchData researchTag = (ResearchNotesItem.ResearchData)stack.get(EidolonDataComponents.RESEARCH);
            if (researchTag == null || researchTag.research() == null) {
                return;
            }
            Research r = Researches.find(researchTag.research());
            if (r == null) {
                return;
            }
            List<ResearchTask> tasks = r.getTasks(this.getSeed(stack), researchTag.stepsDone());
            if (tasks.size() < index) {
                return;
            }
            ResearchTask toComplete = tasks.get(index);
            int startingSlot = 38;
            for (int i = 0; i < index; ++i) {
                startingSlot += tasks.get(i).getSlotCount();
            }
            if (!toComplete.isComplete(this, player, startingSlot).complete()) {
                return;
            }
            toComplete.onComplete(this, player, startingSlot);
            this.setData(0, 200);
            this.broadcastChanges();
            this.updateSlots();
        }
    }

    public void tryStamp(Player player) {
        if (((Slot)this.slots.get(0)).getItem().is((Item)Registry.RESEARCH_NOTES.get()) && ((Slot)this.slots.get(1)).getItem().is((Item)Registry.ARCANE_SEAL.get())) {
            ItemStack notes = ((Slot)this.slots.getFirst()).getItem();
            ResearchNotesItem.ResearchData researchTag = (ResearchNotesItem.ResearchData)notes.get(EidolonDataComponents.RESEARCH);
            if (researchTag == null || researchTag.research() == null) {
                return;
            }
            Research r = Researches.find(researchTag.research());
            if (r == null) {
                return;
            }
            if (researchTag.stepsDone() < r.getStars()) {
                return;
            }
            ((Slot)this.slots.get(1)).remove(1);
            ItemStack completed = new ItemStack((ItemLike)Registry.COMPLETED_RESEARCH.get());
            completed.set(EidolonDataComponents.RESEARCH, (Object)researchTag);
            ((Slot)this.slots.getFirst()).set(completed);
            this.updateSlots();
        }
    }

    public void slotChanged(@NotNull AbstractContainerMenu menu, int slot, @NotNull ItemStack stack) {
        if (slot == 0) {
            this.updateSlots();
        }
    }

    public void dataChanged(@NotNull AbstractContainerMenu menu, int slot, int value) {
        if (slot == 0 && (value == 0 || value == 200)) {
            this.updateSlots();
        }
    }

    class NotesSlot
    extends Slot {
        public NotesSlot(Container iInventoryIn, int index, int xPosition, int yPosition) {
            super(iInventoryIn, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.is((Item)Registry.RESEARCH_NOTES.get());
        }

        public boolean mayPickup(@NotNull Player pPlayer) {
            if (ResearchTableContainer.this.getProgress() > 0) {
                return false;
            }
            return super.mayPickup(pPlayer);
        }

        public void setChanged() {
            super.setChanged();
            if (ResearchTableContainer.this.tile instanceof ResearchTableTileEntity) {
                ResearchTableContainer.this.updateSlots();
            }
        }

        public int getMaxStackSize() {
            return 1;
        }
    }

    static class SealSlot
    extends Slot {
        public SealSlot(Container iInventoryIn, int index, int xPosition, int yPosition) {
            super(iInventoryIn, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.is((Item)Registry.ARCANE_SEAL.get());
        }

        public int getMaxStackSize() {
            return 64;
        }
    }
}

