/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.spell;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.capability.PatronManaImpl;
import alexthw.eidolon_repraised.common.deity.DeityLocks;
import alexthw.eidolon_repraised.common.spell.StaticSpell;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.util.EntityUtil;
import alexthw.eidolon_repraised.util.KnowledgeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrallSpell
extends StaticSpell {
    public static final TagKey<EntityType<?>> ENTHRALL_BLACKLIST = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Eidolon.prefix("enthrall_blacklist"));
    public static final TagKey<EntityType<?>> ENTHRALL_WHITELIST = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Eidolon.prefix("enthrall_whitelist"));

    public ThrallSpell(ResourceLocation name, Sign ... signs) {
        super(name, 50, signs);
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        EntityHitResult result;
        Entity entity;
        HitResult ray = ThrallSpell.rayTrace((Entity)player, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 3.0, 0.0f, false);
        if (ray instanceof EntityHitResult && (entity = (result = (EntityHitResult)ray).getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living.getType().is(ENTHRALL_WHITELIST) || living.getType().is(EntityTypeTags.UNDEAD) && !living.getType().is(ENTHRALL_BLACKLIST);
        }
        return false;
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        if (world instanceof ServerLevel && player instanceof ServerPlayer) {
            EntityHitResult result;
            Entity entity;
            ServerPlayer sp = (ServerPlayer)player;
            HitResult ray = ThrallSpell.rayTrace((Entity)player, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 3.0, 0.0f, false);
            if (ray instanceof EntityHitResult && (entity = (result = (EntityHitResult)ray).getEntity()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                float actualCost = (float)(2 * this.getCost()) * living.getHealth() / living.getMaxHealth();
                PatronManaImpl manaCap = (PatronManaImpl)player.getCapability(EidolonCapabilities.MANA_CAPABILITY);
                if (manaCap != null && manaCap.getMagic() >= actualCost) {
                    manaCap.takeMagic(actualCost);
                    EntityUtil.enthrall((LivingEntity)player, living);
                    KnowledgeUtil.grantResearchNoToast((Entity)player, DeityLocks.ENTHRALL_UNDEAD);
                } else {
                    sp.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"eidolon_repraised.title.no_mana")));
                }
            }
        }
    }
}

