/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.spell;

import alexthw.eidolon_repraised.api.capability.IMana;
import alexthw.eidolon_repraised.api.capability.IReputation;
import alexthw.eidolon_repraised.api.deity.Deity;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.common.block.GhostLight;
import alexthw.eidolon_repraised.common.deity.Deities;
import alexthw.eidolon_repraised.common.spell.StaticSpell;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.registries.Registry;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;

public class LightSpell
extends StaticSpell {
    final Deity deity;

    public LightSpell(ResourceLocation name, Deity deity, Sign ... signs) {
        super(name, 3, signs);
        this.deity = deity;
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        IReputation reputation = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
        return reputation != null && reputation.getReputation(this.deity.getId()) >= 3.0;
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        EntityHitResult entityHitResult;
        Entity entity;
        HitResult ray = LightSpell.rayTrace((Entity)player, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE), 0.0f, true);
        if (ray instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)ray;
            BlockPos blockPos = blockHitResult.getBlockPos().relative(blockHitResult.getDirection());
            if (world.getBlockState(blockPos).canBeReplaced() && world.isUnobstructed(((Block)Registry.GHOST_LIGHT.get()).defaultBlockState(), blockPos, CollisionContext.of((Entity)player))) {
                BlockState lightBlockState = ((Block)Registry.GHOST_LIGHT.get()).defaultBlockState();
                if (this.deity.getId().equals((Object)Deities.DARK_DEITY_ID)) {
                    lightBlockState = (BlockState)lightBlockState.setValue((Property)GhostLight.DEITY, (Comparable)Boolean.valueOf(false));
                }
                world.setBlockAndUpdate(blockPos, lightBlockState);
                world.sendBlockUpdated(blockPos, world.getBlockState(blockPos), world.getBlockState(blockPos), 2);
                IMana.expendMana(player, this.getCost());
            }
        } else if (ray instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)ray).getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200));
            IMana.expendMana(player, this.getCost());
        }
    }
}

