/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.codex;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.capability.IReputation;
import alexthw.eidolon_repraised.api.deity.Deity;
import alexthw.eidolon_repraised.api.research.Research;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.codex.Chapter;
import alexthw.eidolon_repraised.codex.CodexChapters;
import alexthw.eidolon_repraised.codex.CodexGui;
import alexthw.eidolon_repraised.codex.Page;
import alexthw.eidolon_repraised.codex.TitlePage;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.util.KnowledgeUtil;
import alexthw.eidolon_repraised.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class IndexPage
extends Page {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/gui/codex_index_page.png");
    final List<IndexEntry> entries = new ArrayList<IndexEntry>();

    public IndexPage(IndexEntry ... pages) {
        super(BACKGROUND);
        this.entries.addAll(List.of(pages));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean click(CodexGui gui, int x, int y, int mouseX, int mouseY) {
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!this.entries.get(i).isUnlocked() || mouseX < x + 2 || mouseX > x + 124 || mouseY < y + 8 + i * 20 || mouseY > y + 26 + i * 20) continue;
            gui.changeChapter(this.entries.get((int)i).chapter);
            assert (Minecraft.getInstance().player != null);
            Minecraft.getInstance().player.playNotifySound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, @NotNull GuiGraphics mStack, ResourceLocation bg, int x, int y, int mouseX, int mouseY) {
        for (int i = 0; i < this.entries.size(); ++i) {
            IndexEntry entry = this.entries.get(i);
            boolean unlocked = entry.isUnlocked();
            if (entry.alwaysRender || unlocked) {
                mStack.blit(bg, x + 1, y + 7 + i * 20, 128, unlocked ? 0 : 96, 122, 18);
            }
            if (!unlocked) continue;
            mStack.renderItem(entry.icon, x + 2, y + 8 + i * 20);
            String string = I18n.get((String)entry.chapter.titleKey, (Object[])new Object[0]);
            Objects.requireNonNull(Minecraft.getInstance().font);
            IndexPage.drawText(mStack, string, x + 24, y + 20 + i * 20 - 9);
        }
    }

    public static class IndexEntry {
        final Chapter chapter;
        final ItemStack icon;
        boolean alwaysRender = false;

        public IndexEntry(Chapter chapter, ItemStack icon) {
            this.chapter = chapter;
            this.icon = icon;
            if (RegistryUtil.getRegistryName(icon.getItem()).getNamespace().equals("eidolon_repraised")) {
                CodexChapters.itemToEntryMap.put(icon.getItem(), this);
            }
            for (Page p : chapter.pages) {
                if (!(p instanceof TitlePage)) continue;
                TitlePage t = (TitlePage)p;
                if (t.reference.isEmpty()) continue;
                CodexChapters.itemToEntryMap.put(t.reference.getItem(), this);
            }
        }

        public IndexEntry(Chapter chapter, ItemStack icon, boolean alwaysRender) {
            this.chapter = chapter;
            this.icon = icon;
            this.alwaysRender = alwaysRender;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean isUnlocked() {
            return true;
        }
    }

    public static class ReputationLockedEntry
    extends IndexEntry {
        final int reputation;
        final ResourceLocation deity;

        public ReputationLockedEntry(Chapter chapter, ItemStack icon, int reputation, Deity deity) {
            super(chapter, icon);
            this.reputation = reputation;
            this.deity = deity.getId();
        }

        @Override
        public boolean isUnlocked() {
            Player player = Eidolon.proxy.getPlayer();
            if (player == null) {
                return true;
            }
            IReputation reputationCap = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
            return reputationCap == null || reputationCap.getReputation(this.deity) >= (double)this.reputation;
        }
    }

    public static class ResearchLockedEntry
    extends IndexEntry {
        final Research[] researches;

        public ResearchLockedEntry(Chapter chapter, ItemStack icon, Research ... researches) {
            super(chapter, icon);
            this.researches = researches;
        }

        @Override
        public boolean isUnlocked() {
            return Arrays.stream(this.researches).allMatch(research -> KnowledgeUtil.knowsResearch(Eidolon.proxy.getPlayer(), research.getRegistryName()));
        }
    }

    public static class FactLockedEntry
    extends IndexEntry {
        final ResourceLocation[] facts;

        public FactLockedEntry(Chapter chapter, ItemStack icon, ResourceLocation ... facts) {
            super(chapter, icon);
            this.facts = facts;
        }

        @Override
        public boolean isUnlocked() {
            return Arrays.stream(this.facts).allMatch(fact -> KnowledgeUtil.knowsFact(Eidolon.proxy.getPlayer(), fact));
        }
    }

    public static class SignLockedEntry
    extends IndexEntry {
        final Sign[] signs;

        public SignLockedEntry(Chapter chapter, ItemStack icon, Sign ... signs) {
            super(chapter, icon);
            this.signs = signs;
        }

        @Override
        public boolean isUnlocked() {
            for (Sign sign : this.signs) {
                if (KnowledgeUtil.knowsSign(Eidolon.proxy.getPlayer(), sign)) continue;
                return false;
            }
            return true;
        }
    }
}

