/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.datagen;

import alexthw.eidolon_repraised.util.DamageTypeData;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class EidDamageProvider {

    public static class DamageTypeTagGen
    extends TagsProvider<DamageType> {
        private final String namespace;

        public DamageTypeTagGen(String namespace, PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pLookupProvider, ExistingFileHelper existingFileHelper) {
            super(pOutput, Registries.DAMAGE_TYPE, pLookupProvider, namespace, existingFileHelper);
            this.namespace = namespace;
        }

        public DamageTypeTagGen(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pLookupProvider, ExistingFileHelper existingFileHelper) {
            this("eidolon_repraised", pOutput, pLookupProvider, existingFileHelper);
        }

        protected void addTags(@NotNull HolderLookup.Provider provider) {
            HashMultimap tagsToTypes = HashMultimap.create();
            DamageTypeData.allInNamespace(this.namespace).forEach(arg_0 -> DamageTypeTagGen.lambda$addTags$1((Multimap)tagsToTypes, arg_0));
            tagsToTypes.asMap().forEach((tag, keys) -> {
                TagsProvider.TagAppender appender = this.tag((TagKey)tag);
                keys.forEach(key -> appender.addOptional(key.location()));
            });
        }

        private static /* synthetic */ void lambda$addTags$1(Multimap tagsToTypes, DamageTypeData data) {
            data.tags.forEach(tag -> tagsToTypes.put(tag, data.key));
        }
    }

    public static class DamageTypeDataProvider
    extends DatapackBuiltinEntriesProvider {
        private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, DamageTypeDataProvider::bootstrap);

        public static void bootstrap(BootstrapContext<DamageType> ctx) {
            DamageTypeData.allInNamespace("eidolon_repraised").forEach(data -> data.register(ctx));
        }

        public DamageTypeDataProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries, BUILDER, Set.of("eidolon_repraised"));
        }

        public static DataProvider.Factory<DamageTypeDataProvider> makeFactory(CompletableFuture<HolderLookup.Provider> registries) {
            return output -> new DamageTypeDataProvider(output, registries);
        }

        @NotNull
        public String getName() {
            return "Eidolon's Damage Type Data";
        }
    }
}

