/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.datagen;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.registries.DecoBlockPack;
import alexthw.eidolon_repraised.registries.Registry;
import alexthw.eidolon_repraised.util.RegistryUtil;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class EidBlockStateProvider
extends BlockStateProvider {
    private final ExistingFileHelper fileHelper;

    public EidBlockStateProvider(DataGenerator gen, ExistingFileHelper fileHelper) {
        super(gen.getPackOutput(), "eidolon_repraised", fileHelper);
        this.fileHelper = fileHelper;
    }

    protected void registerStatesAndModels() {
        DecoBlockPack.WoodDecoBlock[] button_pplate_sign;
        for (DecoBlockPack.WoodDecoBlock pack : button_pplate_sign = new DecoBlockPack.WoodDecoBlock[]{Registry.ILLWOOD_PLANKS, Registry.POLISHED_PLANKS}) {
            ResourceLocation baseTex = Eidolon.prefix("block/" + pack.baseBlockName);
            this.buttonBlock(pack.getButton(), baseTex);
            this.signBlock(pack.getStandingSign(), pack.getWallSign(), baseTex);
            this.pressurePlateBlock(pack.getPressurePlate(), baseTex);
        }
        this.horizontalBlock((Block)Registry.SCRIPTORIUM.get(), state -> new ModelFile.ExistingModelFile(Eidolon.prefix("item/scriptorium"), this.fileHelper));
    }

    public void pressurePlateBlock(PressurePlateBlock block, ModelFile pressurePlate, ModelFile pressurePlateDown) {
        super.pressurePlateBlock(block, pressurePlate, pressurePlateDown);
        this.simpleBlockItem((Block)block, pressurePlate);
    }

    String name(Block block) {
        return RegistryUtil.getRegistryName(block).getPath();
    }
}

