package alexthw.eidolon_repraised.client;

import com.google.common.collect.ImmutableList;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

public class ClientConfig {
    // graphics
    public static ModConfigSpec.ConfigValue<Boolean> BETTER_LAYERING;
    // ui
    public static ModConfigSpec.ConfigValue<String> MANA_BAR_POSITION, MANA_BAR_ORIENTATION;
    
    public static class Positions {
        public static final String BOTTOM_LEFT = "bottomLeft",
                LEFT = "left",
                TOP_LEFT = "topLeft",
                TOP = "top",
                TOP_RIGHT = "topRight",
                RIGHT = "right",
                BOTTOM_RIGHT = "bottomRight";
        public static final List<String> VALUES = ImmutableList.of(BOTTOM_LEFT, LEFT, TOP_LEFT, TOP, TOP_RIGHT, RIGHT, BOTTOM_RIGHT);
    }
    
    public static class Orientations {
        public static final String HORIZONTAL = "horizontal",
                VERTICAL = "vertical",
                DEFAULT = "default";

        public static final List<String> VALUES = ImmutableList.of(HORIZONTAL, VERTICAL, DEFAULT);
    }

    public ClientConfig(ModConfigSpec.Builder builder) {
        builder.comment("Graphics settings").push("graphics");
        BETTER_LAYERING = builder.comment("Enable better particle/effect layering.",
                        "Fixes particles and effects rendering behind clouds and weather.",
                        "NOTE: Does NOT work with fabulous graphics mode.")
            .define("betterLayering", true);
        builder.pop();
        builder.comment("UI settings").push("ui");
        MANA_BAR_POSITION = builder.comment("Onscreen positioning of the magic power meter.")
                .defineInList("manaBarPosition", "top", Positions.VALUES);
        MANA_BAR_ORIENTATION = builder.comment("Orientation of the magic power meter.")
                .defineInList("manaBarOrientation", "default", Orientations.VALUES);
        builder.pop();
    }

    public static final ClientConfig INSTANCE;
    public static final ModConfigSpec SPEC;

    static {
        final Pair<ClientConfig, ModConfigSpec> specPair = new ModConfigSpec.Builder().configure(ClientConfig::new);
        SPEC = specPair.getRight();
        INSTANCE = specPair.getLeft();
    }
}
