/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.gui;

import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.client.ClientRegistry;
import alexthw.eidolon_repraised.codex.Page;
import alexthw.eidolon_repraised.codex.SignIndexPage;
import alexthw.eidolon_repraised.util.ClientInfo;
import alexthw.eidolon_repraised.util.RenderUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;

public class SignButton
extends Button {
    protected Sign sign;

    protected SignButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, Button.CreateNarration pCreateNarration) {
        super(pX, pY, pWidth, pHeight, pMessage, pOnPress, pCreateNarration);
    }

    public SignButton(int x, int y, int w, int h, Sign sign, Button.OnPress onPress) {
        this(x, y, w, h, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.sign = sign;
    }

    public void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        boolean infoHover = this.isMouseOver(pMouseX, pMouseY);
        PoseStack mStack = pGuiGraphics.pose();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShader(ClientRegistry::getGlowingSpriteShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SignIndexPage.BACKGROUND);
        mStack.pushPose();
        mStack.translate((float)(this.getX() + 24), (float)(this.getY() + 24), 0.0f);
        mStack.mulPose(Axis.ZP.rotationDegrees(ClientInfo.getClientPartialTicks() * 1.5f));
        Page.colorBlit(mStack, -18, -18, 128, 48, 36, 36, 256, 256, this.sign.color());
        mStack.popPose();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        float flicker = 0.75f + 0.05f * (float)Math.sin(Math.toRadians(12.0f * ClientInfo.getClientPartialTicks()));
        for (int j = 0; j < (!infoHover ? 1 : 2); ++j) {
            RenderUtil.litQuad(mStack, (MultiBufferSource)bufferSource, this.getX() + 12, this.getY() + 12, 24.0, 24.0, this.sign.getRed() * flicker, this.sign.getGreen() * flicker, this.sign.getBlue() * flicker, (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(this.sign.sprite()));
            bufferSource.endBatch();
        }
        RenderSystem.disableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        if (infoHover) {
            pGuiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)"eidolon_repraised.codex.sign_suffix", (Object[])new Object[]{Component.translatable((String)(this.sign.getRegistryName().getNamespace() + ".sign." + this.sign.getRegistryName().getPath()))}), pMouseX, pMouseY);
        }
    }
}

