/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.api.ritual;

import alexthw.eidolon_repraised.api.ritual.IRequirement;
import alexthw.eidolon_repraised.api.ritual.IRitualItemProvider;
import alexthw.eidolon_repraised.api.ritual.RequirementInfo;
import alexthw.eidolon_repraised.api.ritual.Ritual;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.network.RitualConsumePacket;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

public class ItemRequirement
implements IRequirement {
    final Ingredient match;

    public ItemRequirement(Ingredient item) {
        this.match = item;
    }

    public ItemRequirement(ItemStack item) {
        this.match = item.isComponentsPatchEmpty() ? Ingredient.of((ItemStack[])new ItemStack[]{item}) : DataComponentIngredient.of((boolean)false, (ItemStack)item);
    }

    public ItemRequirement(Item item) {
        this.match = Ingredient.of((ItemLike[])new ItemLike[]{item});
    }

    public ItemRequirement(Block block) {
        this.match = Ingredient.of((ItemLike[])new ItemLike[]{block});
    }

    public ItemRequirement(TagKey<Item> item) {
        this.match = Ingredient.of(item);
    }

    @Override
    public RequirementInfo isMet(Ritual ritual, Level world, BlockPos pos) {
        List<IRitualItemProvider> tiles = Ritual.getTilesWithinAABB(IRitualItemProvider.class, world, ritual.getSearchBounds(pos));
        if (tiles.isEmpty()) {
            return RequirementInfo.FALSE;
        }
        for (IRitualItemProvider tile : tiles) {
            ItemStack stack = tile.provide();
            if (!this.match.test(stack)) continue;
            return new RequirementInfo(true, ((BlockEntity)tile).getBlockPos());
        }
        return RequirementInfo.FALSE;
    }

    @Override
    public void whenMet(Ritual ritual, Level world, BlockPos pos, RequirementInfo info) {
        ((IRitualItemProvider)world.getBlockEntity(info.getPos())).take();
        if (!world.isClientSide) {
            Networking.sendToNearbyClient(world, pos.above(2), (CustomPacketPayload)new RitualConsumePacket(info.getPos(), pos.above(2), ritual.getRed(), ritual.getGreen(), ritual.getBlue()));
        }
    }

    @Override
    public int getPriority() {
        return 5;
    }

    public Ingredient getMatch() {
        return this.match;
    }
}

