/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.api.ritual;

import alexthw.eidolon_repraised.client.particle.Particles;
import alexthw.eidolon_repraised.common.tile.CenserTileEntity;
import alexthw.eidolon_repraised.registries.EidolonParticles;
import alexthw.eidolon_repraised.registries.IncenseRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class IncenseRitual {
    protected CenserTileEntity censer;
    protected Player player;
    protected ResourceLocation registryName;
    int maxDuration;

    public IncenseRitual(int maxDuration, ResourceLocation registryName) {
        this.maxDuration = maxDuration;
        this.registryName = registryName;
    }

    public boolean start(@Nullable Player player, CenserTileEntity censer) {
        this.censer = censer;
        this.player = player;
        return true;
    }

    public void tick(int age) {
        if (this.censer != null) {
            if (age < this.maxDuration) {
                this.tickEffect(age);
            } else {
                this.censer.extinguish();
            }
        }
    }

    public void tickEffect(int age) {
    }

    public void write(CompoundTag tag) {
        CompoundTag contextTag = new CompoundTag();
        if (this.registryName != null) {
            contextTag.putString("incenseRegistryName", this.registryName.toString());
        }
        tag.put("incenseContext", (Tag)contextTag);
    }

    public static IncenseRitual read(CompoundTag tag) {
        CompoundTag contextTag = tag.getCompound("incenseContext");
        ResourceLocation incenseRegistryName = ResourceLocation.tryParse((String)contextTag.getString("incenseRegistryName"));
        return IncenseRegistry.getIncenseRitual(incenseRegistryName);
    }

    protected int range() {
        return 10;
    }

    public float getRed() {
        return 1.0f;
    }

    public float getGreen() {
        return 0.5f;
    }

    public float getBlue() {
        return 0.3f;
    }

    public void animateParticles(CenserTileEntity censer, int burnCounter) {
        this.animateParticles(burnCounter, censer.getBlockPos(), censer.getLevel());
    }

    public void animateParticles(int burnCounter, BlockPos blockPos, Level level) {
        float x = (float)blockPos.getX() + 0.5f;
        float y = (float)blockPos.getY() + 0.45f;
        float z = (float)blockPos.getZ() + 0.5f;
        float r = this.getRed();
        float g = this.getGreen();
        float b = this.getBlue();
        if (burnCounter < 160) {
            Particles.create((ParticleType)EidolonParticles.FLAME_PARTICLE.get()).setAlpha(0.5f, 0.0f).setScale(0.25f, 0.125f).setLifetime(20).randomOffset(0.125, 0.125).randomVelocity(0.00625f, 0.01875f).addVelocity(0.0, 0.00625f, 0.0).setColor(r, g, b, r, g * 0.5f, b * 1.5f).spawn(level, x, y, z);
        }
        assert (level != null);
        if (level.random.nextInt(20) == 0) {
            Particles.create((ParticleType)EidolonParticles.SPARKLE_PARTICLE.get()).setAlpha(1.0f, 0.0f).setScale(0.0625f, 0.0f).setLifetime(40).randomOffset(0.0625, 0.0).randomVelocity(0.125, 0.0).addVelocity(0.0, 0.125, 0.0).setColor(r, g * 1.5f, b * 2.0f, r, g, b).enableGravity().setSpin(0.4f).spawn(level, x, y, z);
        }
        if (level.random.nextInt(5) == 0) {
            Particles.create((ParticleType)EidolonParticles.SMOKE_PARTICLE.get()).setAlpha(0.25f, 0.0f).setScale(0.375f, 0.125f).setLifetime(160).randomOffset(0.25, 0.125).randomVelocity(0.025f, 0.025f).addVelocity(0.0, 0.0125f, 0.0).setColor(0.5f, 0.5f, 0.5f, 0.25f, 0.25f, 0.25f).spawn(level, x, (double)y + 0.125, z);
        }
    }
}

