/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.network;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.gui.ScriptoriumContainer;
import alexthw.eidolon_repraised.network.AbstractPacket;
import alexthw.eidolon_repraised.registries.Signs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class InscribePacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<InscribePacket> TYPE = new CustomPacketPayload.Type(Eidolon.prefix("inscribe"));
    public static final StreamCodec<RegistryFriendlyByteBuf, InscribePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), pkt -> pkt.signs.stream().map(s -> s.getRegistryName().toString()).toList(), (StreamCodec)ByteBufCodecs.INT, pkt -> pkt.id, (runes, id) -> new InscribePacket((int)id, runes.stream().map(s -> Signs.find(ResourceLocation.tryParse((String)s))).toList()));
    final List<Sign> signs = new ArrayList<Sign>();
    final int id;

    public InscribePacket(int uuid, List<Sign> runes) {
        this.signs.addAll(runes);
        this.id = uuid;
    }

    public static void encode(InscribePacket object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.signs.size());
        for (int i = 0; i < object.signs.size(); ++i) {
            buffer.writeUtf(object.signs.get(i).getRegistryName().toString(), 255);
        }
        buffer.writeInt(object.id);
    }

    public static InscribePacket decode(FriendlyByteBuf buffer) {
        int n = buffer.readInt();
        ArrayList<Sign> runes = new ArrayList<Sign>();
        for (int i = 0; i < n; ++i) {
            runes.add(Signs.find(ResourceLocation.tryParse((String)buffer.readUtf(255))));
        }
        return new InscribePacket(buffer.readInt(), runes);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        if (player == null || player.containerMenu.containerId != this.id) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ScriptoriumContainer) {
            ScriptoriumContainer container = (ScriptoriumContainer)abstractContainerMenu;
            container.setChant(this.signs);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<InscribePacket> type() {
        return TYPE;
    }
}

