/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.potion;

import alexthw.eidolon_repraised.util.ColorUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.extensions.IMobEffectExtension;
import org.jetbrains.annotations.NotNull;

public class UndeathEffect
extends MobEffect
implements IMobEffectExtension {
    protected static final ResourceLocation EFFECT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"textures/mob_effect/undeath.png");

    public UndeathEffect() {
        super(MobEffectCategory.HARMFUL, ColorUtil.packColor(255, 51, 39, 42));
    }

    public boolean applyEffectTick(@NotNull LivingEntity livingEntity, int amplifier) {
        if (this.isSunBurnTick(livingEntity)) {
            boolean flag = true;
            ItemStack itemstack = livingEntity.getItemBySlot(EquipmentSlot.HEAD);
            if (!itemstack.isEmpty()) {
                if (itemstack.isDamageableItem()) {
                    Item item = itemstack.getItem();
                    itemstack.setDamageValue(itemstack.getDamageValue() + livingEntity.getRandom().nextInt(2));
                    if (itemstack.getDamageValue() >= itemstack.getMaxDamage()) {
                        livingEntity.onEquippedItemBroken(item, EquipmentSlot.HEAD);
                        livingEntity.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                    }
                }
                flag = false;
            }
            if (flag) {
                livingEntity.igniteForSeconds(8.0f);
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }

    protected boolean isSunBurnTick(LivingEntity entity) {
        if (entity.level().isDay() && !entity.level().isClientSide) {
            float f = entity.getLightLevelDependentMagicValue();
            BlockPos blockpos = BlockPos.containing((double)entity.getX(), (double)entity.getEyeY(), (double)entity.getZ());
            boolean flag = entity.isInWaterRainOrBubble() || entity.isInPowderSnow || entity.wasInPowderSnow;
            return f > 0.5f && entity.getRandom().nextFloat() * 30.0f < (f - 0.4f) * 2.0f && !flag && entity.level().canSeeSky(blockpos);
        }
        return false;
    }
}

