/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.client.particle;

import alexthw.eidolon_repraised.client.particle.RuneParticle;
import alexthw.eidolon_repraised.client.particle.RuneParticleData;
import com.mojang.serialization.MapCodec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;

public class RuneParticleType
extends ParticleType<RuneParticleData> {
    public RuneParticleType() {
        super(false);
    }

    @NotNull
    public MapCodec<RuneParticleData> codec() {
        return RuneParticleData.codecFor();
    }

    @NotNull
    public StreamCodec<? super RegistryFriendlyByteBuf, RuneParticleData> streamCodec() {
        return RuneParticleData.streamCodecFor();
    }

    public static class Factory
    implements ParticleProvider<RuneParticleData> {
        public Particle createParticle(@NotNull RuneParticleData data, @NotNull ClientLevel world, double x, double y, double z, double mx, double my, double mz) {
            final RuneParticle ret = new RuneParticle(world, data, x, y, z, mx, my, mz);
            ret.pickSprite(new SpriteSet(){

                @NotNull
                public TextureAtlasSprite get(int particleAge, int particleMaxAge) {
                    return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ret.rune.getSprite());
                }

                @NotNull
                public TextureAtlasSprite get(@NotNull RandomSource rand) {
                    return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ret.rune.getSprite());
                }
            });
            return ret;
        }
    }
}

