/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.client.particle;

import alexthw.eidolon_repraised.client.particle.GenericParticleData;
import alexthw.eidolon_repraised.client.particle.SpriteParticleRenderType;
import java.awt.Color;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class GenericParticle
extends TextureSheetParticle {
    final GenericParticleData data;
    final float[] hsv1 = new float[3];
    final float[] hsv2 = new float[3];

    public GenericParticle(ClientLevel world, GenericParticleData data, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.setPos(x, y, z);
        this.data = data;
        this.xd = vx;
        this.yd = vy;
        this.zd = vz;
        this.setLifetime(data.lifetime);
        this.gravity = data.gravity ? 1.0f : 0.0f;
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, data.r1)), (int)(255.0f * Math.min(1.0f, data.g1)), (int)(255.0f * Math.min(1.0f, data.b1)), this.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, data.r2)), (int)(255.0f * Math.min(1.0f, data.g2)), (int)(255.0f * Math.min(1.0f, data.b2)), this.hsv2);
        this.updateTraits();
    }

    protected float getCoeff() {
        return (float)this.age / (float)this.lifetime;
    }

    protected void updateTraits() {
        float coeff = this.getCoeff();
        this.quadSize = Mth.lerp((float)coeff, (float)this.data.scale1, (float)this.data.scale2);
        float h = Mth.rotLerp((float)coeff, (float)(360.0f * this.hsv1[0]), (float)(360.0f * this.hsv2[0])) / 360.0f;
        float s = Mth.lerp((float)coeff, (float)this.hsv1[1], (float)this.hsv2[1]);
        float v = Mth.lerp((float)coeff, (float)this.hsv1[2], (float)this.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)FastColor.ARGB32.red((int)packed) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)packed) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)packed) / 255.0f;
        this.setColor(r, g, b);
        this.setAlpha(Mth.lerp((float)coeff, (float)this.data.a1, (float)this.data.a2));
        this.oRoll = this.roll;
        this.roll += this.data.spin;
    }

    public void tick() {
        this.updateTraits();
        super.tick();
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return SpriteParticleRenderType.INSTANCE;
    }
}

