/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.datagen;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.datagen.SimpleDataProvider;
import alexthw.eidolon_repraised.recipe.ForagingRecipe;
import alexthw.eidolon_repraised.registries.Registry;
import alexthw.eidolon_repraised.util.RegistryUtil;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class EidForagingProvider
extends SimpleDataProvider {
    List<ForagingRecipe> recipes = new ArrayList<ForagingRecipe>();

    public EidForagingProvider(DataGenerator gen) {
        super(gen);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addRecipes();
        for (ForagingRecipe recipe : this.recipes) {
            Path path = EidForagingProvider.getRecipePath(this.output, recipe.id.getPath());
            this.saveStable(pOutput, (JsonElement)recipe.toJson(), path);
        }
    }

    private void addRecipes() {
        this.addForaging((ItemLike)Registry.SILDRIAN_SEED.get(), Blocks.JUNGLE_LEAVES);
        this.addForaging((ItemLike)Registry.OANNA_BLOOM.get(), Blocks.LILY_PAD);
        this.addForaging((ItemLike)Registry.MERAMMER_ROOT.get(), Blocks.OXEYE_DAISY, Blocks.LILY_OF_THE_VALLEY, Blocks.WHITE_TULIP);
        this.addForaging((ItemLike)Registry.AVENNIAN_SPRIG.get(), Blocks.FERN, Blocks.LARGE_FERN);
        this.addForaging((ItemLike)Registry.MIRECAP.get(), Blocks.CRIMSON_FUNGUS, Blocks.WARPED_FUNGUS);
    }

    public void addForaging(ItemLike result, Block ... blocks) {
        this.recipes.add(new ForagingRecipe(Eidolon.prefix("forage_" + RegistryUtil.getRegistryName(result.asItem()).getPath()), new ItemStack(result), Ingredient.of((ItemLike[])blocks)));
    }

    public void addForaging(ItemLike result, TagKey<Item> blockItemTag) {
        this.recipes.add(new ForagingRecipe(Eidolon.prefix("forage_" + RegistryUtil.getRegistryName(result.asItem()).getPath()), new ItemStack(result), Ingredient.of(blockItemTag)));
    }

    @NotNull
    public String getName() {
        return "Eidolon Foraging";
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/eidolon_repraised/recipe/" + str + ".json");
    }
}

