/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.capability;

import alexthw.eidolon_repraised.api.capability.IReputation;
import alexthw.eidolon_repraised.api.deity.Deity;
import alexthw.eidolon_repraised.common.deity.Deities;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.util.KnowledgeUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ReputationCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"devotion").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"get").then(Commands.argument((String)"deity", (ArgumentType)new DeityArgument()).executes(ctx -> ReputationCommand.applyGet((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> {
            IReputation reputation = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
            if (reputation != null) {
                double devotion = reputation.getReputation(DeityArgument.getDeity(ctx, "deity").getId());
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(player.getName().getString() + " : " + devotion)), false);
            }
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"deity", (ArgumentType)new DeityArgument()).then(Commands.argument((String)"qt", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)100.0)).executes(ctx -> ReputationCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> {
            IReputation reputation = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
            if (reputation != null) {
                reputation.setReputation(DeityArgument.getDeity(ctx, "deity").getId(), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"qt"));
            }
        })))))).then(Commands.literal((String)"tryfix").executes(ctx -> ReputationCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), (player, sources) -> KnowledgeUtil.tryFix(player))))));
    }

    private static int apply(CommandSourceStack sources, Collection<? extends Player> players, BiConsumer<Player, CommandSourceStack> action) {
        for (Player player : players) {
            action.accept(player, sources);
        }
        if (players.size() == 1) {
            sources.sendSuccess(() -> Component.translatable((String)"commands.eidolon_repraised.reputation.success.single", (Object[])new Object[]{((Player)players.iterator().next()).getDisplayName()}), true);
        } else {
            sources.sendSuccess(() -> Component.translatable((String)"commands.eidolon_repraised.reputation.success.multiple", (Object[])new Object[]{players.size()}), true);
        }
        return players.size();
    }

    private static int applyGet(CommandSourceStack sources, Collection<? extends Player> players, BiConsumer<Player, CommandSourceStack> action) {
        for (Player player : players) {
            action.accept(player, sources);
        }
        return players.size();
    }

    public static class DeityArgument
    implements ArgumentType<Deity> {
        private static final DynamicCommandExceptionType UNKNOWN = new DynamicCommandExceptionType(obj -> Component.translatable((String)"argument.eidolon_repraised.deity.unknown", (Object[])new Object[]{obj}));

        public static Deity getDeity(CommandContext<?> context, String name) {
            return (Deity)context.getArgument(name, Deity.class);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            for (Deity s : Deities.getDeities()) {
                if (!s.getId().toString().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(s.getId().toString());
            }
            return builder.buildFuture();
        }

        public Deity parse(StringReader reader) throws CommandSyntaxException {
            ResourceLocation rl = ResourceLocation.read((StringReader)reader);
            Deity s = Deities.find(rl);
            if (s == null) {
                throw UNKNOWN.create((Object)rl.toString());
            }
            return s;
        }

        public static DeityArgument deities() {
            return new DeityArgument();
        }
    }
}

