/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.network;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.spells.SignSequence;
import alexthw.eidolon_repraised.api.spells.Spell;
import alexthw.eidolon_repraised.network.AbstractPacket;
import alexthw.eidolon_repraised.registries.Spells;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SpellCastPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<SpellCastPacket> TYPE = new CustomPacketPayload.Type(Eidolon.prefix("spell_cast"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SpellCastPacket> CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, pkt -> pkt.spell.getRegistryName(), (StreamCodec)ByteBufCodecs.COMPOUND_TAG, pkt -> pkt.seq.serializeNbt(), (StreamCodec)UUIDUtil.STREAM_CODEC, pkt -> pkt.uuid, (StreamCodec)BlockPos.STREAM_CODEC, pkt -> pkt.pos, (spellLoc, seqTag, uuid, pos) -> new SpellCastPacket((UUID)uuid, (BlockPos)pos, (ResourceLocation)spellLoc, SignSequence.deserializeNbt(seqTag)));
    final SignSequence seq;
    final Spell spell;
    final BlockPos pos;
    final UUID uuid;

    public SpellCastPacket(Player player, BlockPos pos, Spell spell, SignSequence seq) {
        this.seq = seq;
        this.pos = pos;
        this.spell = spell;
        this.uuid = player.getUUID();
    }

    public SpellCastPacket(UUID uuid, BlockPos pos, ResourceLocation location, SignSequence seq) {
        this.seq = seq;
        this.pos = pos;
        this.spell = Spells.find(location);
        this.uuid = uuid;
    }

    public static void encode(SpellCastPacket object, FriendlyByteBuf buffer) {
        buffer.writeUtf(object.spell.getRegistryName().toString());
        buffer.writeNbt((Tag)object.seq.serializeNbt());
        buffer.writeUUID(object.uuid);
        buffer.writeBlockPos(object.pos);
    }

    public static SpellCastPacket decode(FriendlyByteBuf buffer) {
        ResourceLocation spell = ResourceLocation.parse((String)buffer.readUtf());
        SignSequence seq = SignSequence.deserializeNbt(buffer.readNbt());
        return new SpellCastPacket(buffer.readUUID(), buffer.readBlockPos(), spell, seq);
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Level world = player.level();
        this.spell.cast(world, this.pos, player, this.seq);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

