/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.codex;

import alexthw.eidolon_repraised.api.ritual.Ritual;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.api.spells.Spell;
import alexthw.eidolon_repraised.codex.ChantPage;
import alexthw.eidolon_repraised.codex.Chapter;
import alexthw.eidolon_repraised.codex.CraftingPage;
import alexthw.eidolon_repraised.codex.CruciblePage;
import alexthw.eidolon_repraised.codex.EntityPage;
import alexthw.eidolon_repraised.codex.ListPage;
import alexthw.eidolon_repraised.codex.Page;
import alexthw.eidolon_repraised.codex.SignPage;
import alexthw.eidolon_repraised.codex.SmeltingPage;
import alexthw.eidolon_repraised.codex.TextPage;
import alexthw.eidolon_repraised.codex.TitlePage;
import alexthw.eidolon_repraised.codex.TitledRitualPage;
import alexthw.eidolon_repraised.codex.WorktablePage;
import alexthw.eidolon_repraised.recipe.CrucibleRecipe;
import alexthw.eidolon_repraised.recipe.WorktableRecipe;
import alexthw.eidolon_repraised.util.RegistryUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodexBuilder {
    private String titleKey;
    private final List<Page> pages = new ArrayList<Page>();
    @Nullable
    private Level level;

    public CodexBuilder() {
    }

    public CodexBuilder(@NotNull Level level) {
        this.level = level;
    }

    public CodexBuilder addSupportedRecipePages(ItemLike item) {
        ResourceLocation key = RegistryUtil.getRegistryName(item);
        if (key == null) {
            return this;
        }
        return this.addSupportedRecipePages(key);
    }

    public CodexBuilder addSupportedRecipePages(ResourceLocation recipeId) {
        if (this.level == null) {
            throw new IllegalStateException("Level is not initialized. Use the constructor with Level parameter if you want to use this.");
        }
        RecipeManager recipeManager = this.level.getRecipeManager();
        recipeManager.byKey(recipeId).ifPresent(holder -> {
            Recipe recipe;
            Recipe recipe2 = recipe = holder.value();
            Objects.requireNonNull(recipe2);
            Recipe selector0$temp = recipe2;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CraftingRecipe.class, SmeltingRecipe.class, WorktableRecipe.class, CrucibleRecipe.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    CraftingRecipe craftingRecipe = (CraftingRecipe)selector0$temp;
                    this.pages.add(new CraftingPage(recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()), holder.id()));
                    break;
                }
                case 1: {
                    SmeltingRecipe smeltingRecipe = (SmeltingRecipe)selector0$temp;
                    this.pages.add(new SmeltingPage(recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()), ((Ingredient)smeltingRecipe.getIngredients().getFirst()).getItems()[0], holder.id()));
                    break;
                }
                case 2: {
                    WorktableRecipe worktableRecipe = (WorktableRecipe)selector0$temp;
                    this.pages.add(new WorktablePage(recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess())));
                    break;
                }
                case 3: {
                    CrucibleRecipe crucibleRecipe = (CrucibleRecipe)selector0$temp;
                    this.pages.add(new CruciblePage(recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()), holder.id()));
                    break;
                }
            }
        });
        return this;
    }

    public CodexBuilder title(String titleKey) {
        this.titleKey = titleKey;
        return this;
    }

    public CodexBuilder titlePage(String textKey) {
        this.addTextPages(textKey, ItemStack.EMPTY, true);
        return this;
    }

    public CodexBuilder titlePage(String textKey, ItemStack reference) {
        this.addTextPages(textKey, reference, true);
        return this;
    }

    public CodexBuilder entityPage(EntityType<?> entity) {
        this.pages.add(new EntityPage(entity));
        return this;
    }

    public CodexBuilder craftingPage(ItemLike output) {
        this.pages.add(new CraftingPage(output.asItem().getDefaultInstance()));
        return this;
    }

    public CodexBuilder craftingPage(ItemStack output) {
        this.pages.add(new CraftingPage(output));
        return this;
    }

    public CodexBuilder craftingPage(ItemStack output, ResourceLocation recipeId) {
        this.pages.add(new CraftingPage(output, recipeId));
        return this;
    }

    public CodexBuilder smeltingPage(ItemStack output, ItemStack input) {
        this.pages.add(new SmeltingPage(output, input));
        return this;
    }

    public CodexBuilder smeltingPage(ItemStack output, ItemStack input, ResourceLocation recipeId) {
        this.pages.add(new SmeltingPage(output, input, recipeId));
        return this;
    }

    public CodexBuilder worktablePage(ItemLike output) {
        this.pages.add(new WorktablePage(output.asItem().getDefaultInstance()));
        return this;
    }

    public CodexBuilder worktablePage(ItemStack output) {
        this.pages.add(new WorktablePage(output));
        return this;
    }

    public CodexBuilder cruciblePage(ItemLike output) {
        this.pages.add(new CruciblePage(output.asItem().getDefaultInstance()));
        return this;
    }

    public CodexBuilder cruciblePage(ItemStack output) {
        this.pages.add(new CruciblePage(output));
        return this;
    }

    public CodexBuilder cruciblePage(ItemStack output, ResourceLocation recipeId) {
        this.pages.add(new CruciblePage(output, recipeId));
        return this;
    }

    public CodexBuilder chantPage(String textKey, Spell spell) {
        this.pages.add(new ChantPage(textKey, spell));
        return this;
    }

    public CodexBuilder titledRitualPage(String textKey, ResourceLocation ritualId) {
        this.pages.add(new TitledRitualPage(textKey, ritualId));
        return this;
    }

    public CodexBuilder titledRitualPage(String textKey, ItemStack ritualResult) {
        this.pages.add(new TitledRitualPage(textKey, ritualResult));
        return this;
    }

    public CodexBuilder titledRitualPage(String textKey, Ritual ritual) {
        this.pages.add(new TitledRitualPage(textKey, ritual));
        return this;
    }

    public CodexBuilder listPage(String textKey, ListPage.ListEntry ... entries) {
        this.pages.add(new ListPage(textKey, entries));
        return this;
    }

    public CodexBuilder signPage(Sign sign) {
        this.pages.add(new SignPage(sign));
        return this;
    }

    public Chapter build() {
        if (this.titleKey == null) {
            throw new IllegalStateException("Chapter must have a title.");
        }
        return new Chapter(this.titleKey, this.pages.toArray(new Page[0]));
    }

    public CodexBuilder textPage(String translationKey) {
        this.addTextPages(translationKey, ItemStack.EMPTY, false);
        return this;
    }

    private void addTextPages(String translationKey, ItemStack icon, boolean isTitlePage) {
        MutableComponent text = Component.translatable((String)translationKey);
        String rawText = text.getString();
        String[] sentences = rawText.split("(?<=[.!?])\\s+");
        ArrayList<String> lines = new ArrayList<String>();
        for (String sentence : sentences) {
            List<String> sentenceLines = Page.wrapTextToLines(sentence, 120);
            lines.addAll(sentenceLines);
        }
        int linesPerPage = isTitlePage ? 12 : 13;
        int totalLines = lines.size();
        int pagesNeeded = (int)Math.ceil((double)totalLines / (double)linesPerPage);
        for (int i = 0; i < pagesNeeded; ++i) {
            int startLine = i * linesPerPage;
            int endLine = Math.min((i + 1) * linesPerPage, totalLines);
            List pageLines = lines.subList(startLine, endLine);
            String pageText = String.join((CharSequence)" ", pageLines);
            if (i == 0 && isTitlePage) {
                this.pages.add(icon.isEmpty() ? new TitlePage(pageText, translationKey + ".title") : new TitlePage(pageText, icon));
                continue;
            }
            this.pages.add(new TextPage(pageText));
        }
    }
}

