/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.network;

import alexthw.eidolon_repraised.network.AbstractPacket;
import alexthw.eidolon_repraised.network.AttemptCastPacket;
import alexthw.eidolon_repraised.network.ChilledEffectPacket;
import alexthw.eidolon_repraised.network.CrucibleFailPacket;
import alexthw.eidolon_repraised.network.CrucibleSuccessPacket;
import alexthw.eidolon_repraised.network.CrystallizeEffectPacket;
import alexthw.eidolon_repraised.network.DeathbringerSlashEffectPacket;
import alexthw.eidolon_repraised.network.ExtinguishEffectPacket;
import alexthw.eidolon_repraised.network.FeatherEffectPacket;
import alexthw.eidolon_repraised.network.FlameEffectPacket;
import alexthw.eidolon_repraised.network.GenericParticlePacket;
import alexthw.eidolon_repraised.network.IgniteEffectPacket;
import alexthw.eidolon_repraised.network.InitCodexPacket;
import alexthw.eidolon_repraised.network.InscribePacket;
import alexthw.eidolon_repraised.network.KnowledgeUpdatePacket;
import alexthw.eidolon_repraised.network.LifestealEffectPacket;
import alexthw.eidolon_repraised.network.MagicBurstEffectPacket;
import alexthw.eidolon_repraised.network.OpenCodexPacket;
import alexthw.eidolon_repraised.network.ReputationUpdatePacket;
import alexthw.eidolon_repraised.network.ResearchActionPacket;
import alexthw.eidolon_repraised.network.RitualCompletePacket;
import alexthw.eidolon_repraised.network.RitualConsumePacket;
import alexthw.eidolon_repraised.network.SoulUpdatePacket;
import alexthw.eidolon_repraised.network.SpellCastPacket;
import alexthw.eidolon_repraised.network.TESyncPacket;
import alexthw.eidolon_repraised.network.WingsDashPacket;
import alexthw.eidolon_repraised.network.WingsDataUpdatePacket;
import alexthw.eidolon_repraised.network.WingsFlapPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class Networking {
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar reg = event.registrar("eidolon_repraised");
        reg.playToClient(GenericParticlePacket.TYPE, GenericParticlePacket.CODEC, Networking::handle);
        reg.playToClient(ChilledEffectPacket.TYPE, ChilledEffectPacket.CODEC, Networking::handle);
        reg.playToClient(TESyncPacket.TYPE, TESyncPacket.CODEC, Networking::handle);
        reg.playToClient(ExtinguishEffectPacket.TYPE, ExtinguishEffectPacket.CODEC, Networking::handle);
        reg.playToClient(IgniteEffectPacket.TYPE, IgniteEffectPacket.CODEC, Networking::handle);
        reg.playToClient(FlameEffectPacket.TYPE, FlameEffectPacket.CODEC, Networking::handle);
        reg.playToClient(RitualCompletePacket.TYPE, RitualCompletePacket.CODEC, Networking::handle);
        reg.playToClient(RitualConsumePacket.TYPE, RitualConsumePacket.CODEC, Networking::handle);
        reg.playToClient(CrystallizeEffectPacket.TYPE, CrystallizeEffectPacket.CODEC, Networking::handle);
        reg.playToClient(CrucibleFailPacket.TYPE, CrucibleFailPacket.CODEC, Networking::handle);
        reg.playToClient(CrucibleSuccessPacket.TYPE, CrucibleSuccessPacket.CODEC, Networking::handle);
        reg.playToClient(LifestealEffectPacket.TYPE, LifestealEffectPacket.CODEC, Networking::handle);
        reg.playToClient(MagicBurstEffectPacket.TYPE, MagicBurstEffectPacket.CODEC, Networking::handle);
        reg.playToClient(KnowledgeUpdatePacket.TYPE, KnowledgeUpdatePacket.CODEC, Networking::handle);
        reg.playToClient(ReputationUpdatePacket.TYPE, ReputationUpdatePacket.CODEC, Networking::handle);
        reg.playToServer(AttemptCastPacket.TYPE, AttemptCastPacket.CODEC, Networking::handle);
        reg.playToClient(SpellCastPacket.TYPE, SpellCastPacket.CODEC, Networking::handle);
        reg.playToServer(ResearchActionPacket.TYPE, ResearchActionPacket.CODEC, Networking::handle);
        reg.playToClient(DeathbringerSlashEffectPacket.TYPE, DeathbringerSlashEffectPacket.CODEC, Networking::handle);
        reg.playToClient(SoulUpdatePacket.TYPE, SoulUpdatePacket.CODEC, Networking::handle);
        reg.playToServer(WingsFlapPacket.TYPE, WingsFlapPacket.CODEC, Networking::handle);
        reg.playToServer(WingsDashPacket.TYPE, WingsDashPacket.CODEC, Networking::handle);
        reg.playToClient(WingsDataUpdatePacket.TYPE, WingsDataUpdatePacket.CODEC, Networking::handle);
        reg.playToClient(FeatherEffectPacket.TYPE, FeatherEffectPacket.CODEC, Networking::handle);
        reg.playToClient(OpenCodexPacket.TYPE, OpenCodexPacket.CODEC, Networking::handle);
        reg.playToClient(InitCodexPacket.TYPE, InitCodexPacket.CODEC, Networking::handle);
        reg.playToServer(InscribePacket.TYPE, InscribePacket.CODEC, Networking::handle);
    }

    public static <T extends AbstractPacket> void handle(T message, IPayloadContext ctx) {
        if (ctx.flow().getReceptionSide() == LogicalSide.SERVER) {
            Networking.handleServer(message, ctx);
        } else {
            ClientMessageHandler.handleClient(message, ctx);
        }
    }

    private static <T extends AbstractPacket> void handleServer(T message, IPayloadContext ctx) {
        MinecraftServer server = ctx.player().getServer();
        message.onServerReceived(server, (ServerPlayer)ctx.player());
    }

    public static void sendToNearbyClient(Level world, BlockPos pos, CustomPacketPayload toSend) {
        if (world instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)world;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)ws, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)toSend, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToNearbyClient(Level world, Entity e, CustomPacketPayload toSend) {
        Networking.sendToNearbyClient(world, e.blockPosition(), toSend);
    }

    public static void sendToPlayerClient(CustomPacketPayload msg, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToServer(CustomPacketPayload msg) {
        PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static class ClientMessageHandler {
        private ClientMessageHandler() {
        }

        public static <T extends AbstractPacket> void handleClient(T message, IPayloadContext ctx) {
            Minecraft minecraft = Minecraft.getInstance();
            message.onClientReceived(minecraft, (Player)minecraft.player);
        }
    }
}

