/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.spell;

import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.common.spell.StaticSpell;
import alexthw.eidolon_repraised.util.EidolonFakePlayer;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ExecCommandSpell
extends StaticSpell {
    private final List<String> commands;

    public ExecCommandSpell(ResourceLocation id, int manaCost, Sign[] signs, List<String> commands) {
        super(id, manaCost, signs);
        this.commands = commands;
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        return true;
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            MinecraftServer server = world.getServer();
            for (String command : this.commands) {
                if (!server.isCommandBlockEnabled() || StringUtil.isNullOrEmpty((String)command)) continue;
                try {
                    if (player == null) {
                        EidolonFakePlayer fakePlayer = EidolonFakePlayer.getPlayer(serverWorld);
                        fakePlayer.setPos(pos.getCenter());
                        player = fakePlayer;
                    }
                    CommandSourceStack commandSource = player.createCommandSourceStack().withPermission(2).withSuppressedOutput();
                    server.getCommands().performPrefixedCommand(commandSource, command);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Executing command ritual");
                    CrashReportCategory crashreportcategory = crashreport.addCategory("Command to be executed");
                    crashreportcategory.setDetail("Command", (Object)command);
                    throw new ReportedException(crashreport);
                }
            }
        }
    }
}

