/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.capability;

import alexthw.eidolon_repraised.Config;
import alexthw.eidolon_repraised.api.capability.ISoul;
import alexthw.eidolon_repraised.registries.EidolonAttachments;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class SoulImpl
implements ISoul {
    SoulHeartData soulHeartData;
    LivingEntity entity;

    public SoulImpl(LivingEntity entity) {
        this.entity = entity;
        this.soulHeartData = (SoulHeartData)entity.getData(EidolonAttachments.SOUL_ATTACHMENT.get());
    }

    @Override
    public boolean hasEtherealHealth() {
        return this.soulHeartData.maxEtherealHealth > 0.0f;
    }

    @Override
    public float getMaxEtherealHealth() {
        return this.soulHeartData.maxEtherealHealth;
    }

    @Override
    public float getEtherealHealth() {
        return this.soulHeartData.etherealHealth;
    }

    @Override
    public void setEtherealHealth(float health) {
        this.soulHeartData.etherealHealth = Mth.clamp((float)health, (float)0.0f, (float)this.soulHeartData.maxEtherealHealth);
        this.entity.setData(EidolonAttachments.SOUL_ATTACHMENT, (Object)this.soulHeartData);
    }

    @Override
    public void setMaxEtherealHealth(float max) {
        this.soulHeartData.maxEtherealHealth = Mth.clamp((float)max, (float)0.0f, (float)((Integer)Config.MAX_ETHEREAL_HEALTH.get()).intValue());
        this.soulHeartData.etherealHealth = Math.min(this.soulHeartData.maxEtherealHealth, this.soulHeartData.etherealHealth);
        this.entity.setData(EidolonAttachments.SOUL_ATTACHMENT, (Object)this.soulHeartData);
    }

    public CompoundTag serializeNBT() {
        return this.soulHeartData.serializeNBT((HolderLookup.Provider)this.entity.registryAccess());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.soulHeartData.deserializeNBT((HolderLookup.Provider)this.entity.registryAccess(), nbt);
        this.entity.setData(EidolonAttachments.SOUL_ATTACHMENT, (Object)this.soulHeartData);
    }

    public static class SoulHeartData
    implements INBTSerializable<CompoundTag> {
        float maxEtherealHealth;
        float etherealHealth;

        public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            tag.putFloat("maxEtherealHealth", this.maxEtherealHealth);
            tag.putFloat("etherealHealth", this.etherealHealth);
            return tag;
        }

        public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            this.maxEtherealHealth = nbt.contains("maxEtherealHealth") ? nbt.getFloat("maxEtherealHealth") : 0.0f;
            this.etherealHealth = nbt.contains("etherealHealth") ? nbt.getFloat("etherealHealth") : 0.0f;
        }
    }
}

