/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.ritual;

import alexthw.eidolon_repraised.api.ritual.Ritual;
import alexthw.eidolon_repraised.network.CrystallizeEffectPacket;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.util.ColorUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;

public class SummonRitual
extends Ritual {
    public static final ResourceLocation SYMBOL = ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"particle/summon_ritual");
    final EntityType<?> entity;
    final int count;

    public EntityType<?> getEntityType() {
        return this.entity;
    }

    public int getCount() {
        return this.count;
    }

    public SummonRitual(EntityType<?> entity) {
        super(SYMBOL, ColorUtil.packColor(255, 121, 94, 255));
        this.entity = entity;
        this.count = 1;
    }

    public SummonRitual(EntityType<?> entity, int count) {
        super(SYMBOL, ColorUtil.packColor(255, 121, 94, 255));
        this.entity = entity;
        this.count = count;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"eidolon_repraised.ritual.summon", (Object[])new Object[]{this.getEntityType().getDescription()});
    }

    @Override
    public Ritual cloneRitual() {
        return new SummonRitual(this.entity, this.count);
    }

    @Override
    public Ritual.RitualResult start(Level world, BlockPos pos) {
        if (!world.isClientSide) {
            Networking.sendToNearbyClient(world, pos, (CustomPacketPayload)new CrystallizeEffectPacket(pos));
            for (int i = 0; i < this.count; ++i) {
                Entity e = this.entity.create(world);
                if (e == null) continue;
                if (e instanceof Mob) {
                    Mob m = (Mob)e;
                    if (world instanceof ServerLevelAccessor) {
                        ServerLevelAccessor l = (ServerLevelAccessor)world;
                        EventHooks.finalizeMobSpawn((Mob)m, (ServerLevelAccessor)l, (DifficultyInstance)world.getCurrentDifficultyAt(pos), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null);
                        m.setCanPickUpLoot(true);
                    }
                }
                e.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5);
                world.addFreshEntity(e);
            }
        }
        return Ritual.RitualResult.TERMINATE;
    }
}

