/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.item;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.common.item.IManaRelatedItem;
import alexthw.eidolon_repraised.common.item.ItemBase;
import alexthw.eidolon_repraised.registries.EidolonDataComponents;
import alexthw.eidolon_repraised.util.KnowledgeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CodexItem
extends ItemBase
implements IManaRelatedItem {
    public CodexItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos blockpos;
        Level level = pContext.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = pContext.getClickedPos());
        if (blockstate.is(Blocks.LECTERN)) {
            return LecternBlock.tryPlaceBook((LivingEntity)pContext.getPlayer(), (Level)level, (BlockPos)blockpos, (BlockState)blockstate, (ItemStack)pContext.getItemInHand()) ? InteractionResult.sidedSuccess((boolean)level.isClientSide) : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, @NotNull Player entity, @NotNull InteractionHand hand) {
        if (world.isClientSide) {
            entity.playNotifySound(SoundEvents.BOOK_PAGE_TURN, SoundSource.PLAYERS, 1.0f, 1.0f);
            Eidolon.proxy.openCodexGui(entity);
        }
        return InteractionResultHolder.pass((Object)entity.getItemInHand(hand));
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (!world.isClientSide && stack.get(EidolonDataComponents.SIGN) != null) {
            Sign sign = (Sign)stack.get(EidolonDataComponents.SIGN);
            stack.remove(EidolonDataComponents.SIGN);
            if (sign != null) {
                KnowledgeUtil.grantSign(entity, sign);
            }
        }
    }

    public static ItemStack withSign(ItemStack stack, Sign sign) {
        ItemStack newStack = stack.copy();
        newStack.set(EidolonDataComponents.SIGN, (Object)sign);
        return newStack;
    }
}

