/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.capability;

import alexthw.eidolon_repraised.api.capability.IPlayerData;
import alexthw.eidolon_repraised.common.item.IWingsItem;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.network.WingsDashPacket;
import alexthw.eidolon_repraised.network.WingsFlapPacket;
import alexthw.eidolon_repraised.registries.EidolonAttachments;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class WingsDataImpl
implements IPlayerData {
    WingsData wingsData;
    LivingEntity entity;
    static final AttributeModifier WINGS_SLOWFALL = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)"wings_falling"), -0.6, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    public WingsDataImpl(LivingEntity entity) {
        this.entity = entity;
        this.wingsData = (WingsData)entity.getData(EidolonAttachments.WINGS_ATTACHMENT);
    }

    @Override
    public int getWingCharges(Player player) {
        return this.wingsData.wingCharges;
    }

    @Override
    public void rechargeWings(Player player) {
        this.wingsData.wingCharges = this.getMaxWingCharges(player);
        this.entity.setData(EidolonAttachments.WINGS_ATTACHMENT, (Object)this.wingsData);
    }

    @Override
    public boolean tryFlapWings(Player player) {
        if (this.wingsData.wingCharges <= 0 || this.getWingsItem(player).isEmpty()) {
            this.wingsData.wingCharges = 0;
            this.entity.setData(EidolonAttachments.WINGS_ATTACHMENT, (Object)this.wingsData);
            return false;
        }
        if (this.canFlap(player)) {
            --this.wingsData.wingCharges;
            ItemStack wings = this.getWingsItem(player);
            Item item = wings.getItem();
            if (item instanceof IWingsItem) {
                IWingsItem i = (IWingsItem)item;
                if (this.isDashing(player)) {
                    i.onDashFlap(player, player.level(), wings, this.getDashTicks(player));
                } else {
                    i.onFlap(player, player.level(), wings, this.getDashTicks(player));
                }
                this.wingsData.lastFlapTime = player.level().getGameTime();
                this.startFlying(player);
                if (player.level().isClientSide) {
                    Networking.sendToServer(new WingsFlapPacket(player));
                }
            }
            this.entity.setData(EidolonAttachments.WINGS_ATTACHMENT, (Object)this.wingsData);
            return true;
        }
        return false;
    }

    @Override
    public int getDashTicks(Player player) {
        return this.wingsData.dashTicks;
    }

    @Override
    public void doDashTick(Player player) {
        if (this.wingsData.dashTicks > 0) {
            IWingsItem i;
            ItemStack wings = this.getWingsItem(player);
            Item item = wings.getItem();
            if (item instanceof IWingsItem) {
                i = (IWingsItem)item;
                i.onDashTick(player, player.level(), wings, this.wingsData.dashTicks);
            }
            --this.wingsData.dashTicks;
            if (this.wingsData.dashTicks == 0 && (item = wings.getItem()) instanceof IWingsItem) {
                i = (IWingsItem)item;
                i.onDashEnd(player, player.level(), wings);
            }
            this.entity.setData(EidolonAttachments.WINGS_ATTACHMENT, (Object)this.wingsData);
        }
    }

    @Override
    public boolean tryDash(Player player) {
        if (this.wingsData.wingCharges > 0 && this.canFlap(player)) {
            --this.wingsData.wingCharges;
            ItemStack wings = this.getWingsItem(player);
            Item item = wings.getItem();
            if (item instanceof IWingsItem) {
                IWingsItem i = (IWingsItem)item;
                i.onDashStart(player, player.level(), wings);
                this.wingsData.lastFlapTime = player.level().getGameTime();
                if (!this.wingsData.isFlying) {
                    this.wingsData.flightStartTime = this.wingsData.lastFlapTime;
                }
                this.wingsData.isFlying = true;
                this.wingsData.dashTicks = i.getDashTicks(wings);
                this.entity.setData(EidolonAttachments.WINGS_ATTACHMENT, (Object)this.wingsData);
                if (player.level().isClientSide) {
                    Networking.sendToServer(new WingsDashPacket(player));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public long getLastFlapTime(Player player) {
        return this.wingsData.lastFlapTime;
    }

    @Override
    public boolean isFlying(Player player) {
        return this.wingsData.isFlying;
    }

    @Override
    public void startFlying(Player player) {
        if (!this.wingsData.isFlying) {
            this.wingsData.flightStartTime = player.level().getGameTime();
            this.wingsData.isFlying = true;
            AttributeInstance attr = player.getAttribute(Attributes.GRAVITY);
            if (attr != null && !attr.hasModifier(WINGS_SLOWFALL.id())) {
                attr.addTransientModifier(WINGS_SLOWFALL);
            }
        }
    }

    @Override
    public void stopFlying(Player player) {
        if (this.wingsData.isFlying) {
            this.wingsData.isFlying = false;
            if (this.isDashing(player)) {
                this.setDashTicks(0);
                ItemStack wings = this.getWingsItem(player);
                Item item = wings.getItem();
                if (item instanceof IWingsItem) {
                    IWingsItem i = (IWingsItem)item;
                    i.onDashEnd(player, player.level(), wings);
                }
            }
            this.wingsData.flightStartTime = player.level().getGameTime();
            AttributeInstance attr = player.getAttribute(Attributes.GRAVITY);
            if (attr != null && attr.hasModifier(WINGS_SLOWFALL.id())) {
                attr.removeModifier(WINGS_SLOWFALL);
            }
        }
    }

    @Override
    public void setDashTicks(int ticks) {
        this.wingsData.dashTicks = ticks;
        this.entity.setData(EidolonAttachments.WINGS_ATTACHMENT, (Object)this.wingsData);
    }

    @Override
    public void setLastFlapTime(long lastFlapTime) {
        this.wingsData.lastFlapTime = lastFlapTime;
        this.entity.setData(EidolonAttachments.WINGS_ATTACHMENT, (Object)this.wingsData);
    }

    @Override
    public long getFlightStartTime(Player player) {
        return this.wingsData.flightStartTime;
    }

    public static class WingsData
    implements INBTSerializable<CompoundTag> {
        public int wingCharges;
        public int dashTicks;
        public long lastFlapTime;
        public long flightStartTime;
        public boolean isFlying;

        public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("wingCharges", this.wingCharges);
            tag.putInt("dashTicks", this.dashTicks);
            tag.putLong("lastFlapTime", this.lastFlapTime);
            tag.putLong("flightStartTime", this.flightStartTime);
            tag.putBoolean("isFlying", this.isFlying);
            return tag;
        }

        public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
            this.wingCharges = nbt.getInt("wingCharges");
            this.dashTicks = nbt.getInt("dashTicks");
            this.lastFlapTime = nbt.getLong("lastFlapTime");
            this.flightStartTime = nbt.getLong("flightStartTime");
            this.isFlying = nbt.getBoolean("isFlying");
        }
    }
}

