/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.spell;

import alexthw.eidolon_repraised.api.altar.AltarInfo;
import alexthw.eidolon_repraised.api.capability.IReputation;
import alexthw.eidolon_repraised.api.deity.Deity;
import alexthw.eidolon_repraised.api.ritual.Ritual;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.capability.PatronManaImpl;
import alexthw.eidolon_repraised.client.particle.Particles;
import alexthw.eidolon_repraised.common.block.HorizontalBlockBase;
import alexthw.eidolon_repraised.common.spell.StaticSpell;
import alexthw.eidolon_repraised.common.tile.EffigyTileEntity;
import alexthw.eidolon_repraised.common.tile.GobletTileEntity;
import alexthw.eidolon_repraised.network.Networking;
import alexthw.eidolon_repraised.network.SoulUpdatePacket;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.registries.EidolonParticles;
import alexthw.eidolon_repraised.util.RGBProvider;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.ModConfigSpec;

public class PrayerSpell
extends StaticSpell {
    final Deity deity;
    int baseRep = 1;
    double powerMultiplier = 0.25;
    @Nullable
    public ModConfigSpec.IntValue COOLDOWN;
    @Nullable
    public ModConfigSpec.IntValue BASE_REP;
    @Nullable
    public ModConfigSpec.DoubleValue POWER_MULTIPLIER;

    public PrayerSpell(ResourceLocation name, Deity deity, Sign ... signs) {
        super(name, signs);
        this.deity = deity;
    }

    public PrayerSpell(ResourceLocation name, Deity deity, int reputation, double powerMult, Sign ... signs) {
        super(name, signs);
        this.deity = deity;
        this.baseRep = reputation;
        this.powerMultiplier = powerMult;
    }

    public PrayerSpell(ResourceLocation name, Deity deity, int cost, int reputation, double powerMult, Sign ... signs) {
        super(name, cost, signs);
        this.deity = deity;
        this.baseRep = reputation;
        this.powerMultiplier = powerMult;
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        if (this.reputationCheck(world, player, 0.0)) {
            return false;
        }
        EffigyTileEntity effigy = PrayerSpell.getEffigy(world, pos);
        return effigy != null && effigy.ready();
    }

    public static void updateMagic(AltarInfo altarInfo, Player player, Level world, double reputation) {
        PatronManaImpl patronMana = (PatronManaImpl)player.getCapability(EidolonCapabilities.MANA_CAPABILITY);
        if (patronMana != null) {
            double capacity = altarInfo.getCapacity();
            double power = altarInfo.getPower();
            patronMana.setMaxMagic((float)Math.max((double)patronMana.getMaxMagic(), 20.0 + reputation * (1.0 + capacity / 2.0)));
            patronMana.setMagic((float)Math.max((double)patronMana.getMagic(), (double)patronMana.getMagic() + reputation + power * 2.0));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Networking.sendToPlayerClient(new SoulUpdatePacket(player), serverPlayer);
            }
        }
    }

    protected boolean reputationCheck(Level world, Player player, double minDevotion) {
        IReputation reputation = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
        if (reputation == null) {
            return true;
        }
        if (!reputation.canPray(this, world.getGameTime())) {
            player.displayClientMessage((Component)Component.translatable((String)"eidolon_repraised.message.prayer_cooldown"), true);
            return true;
        }
        if (reputation.getReputation(this.deity.getId()) < minDevotion) {
            player.displayClientMessage((Component)Component.translatable((String)"eidolon_repraised.message.not_enough_reputation"), true);
            return true;
        }
        return false;
    }

    @Nullable
    protected static GobletTileEntity getGoblet(Level world, BlockPos pos) {
        List<GobletTileEntity> goblets = Ritual.getTilesWithinAABB(GobletTileEntity.class, world, new AABB(pos.offset(-4, -4, -4).getBottomCenter(), pos.offset(5, 5, 5).getCenter()));
        if (goblets.isEmpty()) {
            return null;
        }
        return goblets.stream().min(Comparator.comparingDouble(e -> e.getBlockPos().distSqr((Vec3i)pos))).get();
    }

    @Nullable
    protected static EffigyTileEntity getEffigy(Level world, BlockPos pos) {
        List<EffigyTileEntity> effigies = Ritual.getTilesWithinAABB(EffigyTileEntity.class, world, new AABB(pos.offset(-4, -4, -4).getBottomCenter(), pos.offset(5, 5, 5).getCenter()));
        if (effigies.isEmpty()) {
            return null;
        }
        return effigies.stream().min(Comparator.comparingDouble(e -> e.getBlockPos().distSqr((Vec3i)pos))).get();
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        EffigyTileEntity effigy = PrayerSpell.getEffigy(world, pos);
        if (effigy == null) {
            return;
        }
        if (!world.isClientSide) {
            effigy.pray();
            AltarInfo info = AltarInfo.getAltarInfo(world, effigy.getBlockPos());
            IReputation reputation = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
            if (reputation != null) {
                reputation.pray(this, world.getGameTime());
                reputation.addReputation(this.deity.getId(), (double)this.getBaseRep() + this.getPowerMultiplier() * info.getPower());
                PrayerSpell.updateMagic(info, player, world, reputation.getReputation(this.deity.getId()));
            }
        } else {
            this.playSuccessSound(world, player, effigy, this.deity);
        }
    }

    protected void playSuccessSound(Level world, Player player, EffigyTileEntity effigy, RGBProvider color) {
        world.playSound(player, effigy.getBlockPos(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.NEUTRAL, 10000.0f, 0.6f + world.random.nextFloat() * 0.2f);
        world.playSound(player, effigy.getBlockPos(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.NEUTRAL, 2.0f, 0.5f + world.random.nextFloat() * 0.2f);
        BlockState state = world.getBlockState(effigy.getBlockPos());
        Direction dir = (Direction)state.getValue((Property)HorizontalBlockBase.HORIZONTAL_FACING);
        Direction tangent = dir.getClockWise();
        float x = (float)effigy.getBlockPos().getX() + 0.5f + (float)dir.getStepX() * 0.21875f;
        float y = (float)effigy.getBlockPos().getY() + 0.8125f;
        float z = (float)effigy.getBlockPos().getZ() + 0.5f + (float)dir.getStepZ() * 0.21875f;
        Particles.create((ParticleType)EidolonParticles.FLAME_PARTICLE.get()).setColor(color.getRed(), color.getGreen(), color.getBlue()).setAlpha(0.5f, 0.0f).setScale(0.125f, 0.0625f).randomOffset(0.01f).randomVelocity(0.0025f).addVelocity(0.0, 0.005f, 0.0).repeat(world, x + 0.09375f * (float)tangent.getStepX(), y, z + 0.09375f * (float)tangent.getStepZ(), 8);
        Particles.create((ParticleType)EidolonParticles.FLAME_PARTICLE.get()).setColor(color.getRed(), color.getGreen(), color.getBlue()).setAlpha(0.5f, 0.0f).setScale(0.1875f, 0.125f).randomOffset(0.01f).randomVelocity(0.0025f).addVelocity(0.0, 0.005f, 0.0).repeat(world, x - 0.09375f * (float)tangent.getStepX(), y, z - 0.09375f * (float)tangent.getStepZ(), 8);
    }

    @Override
    public void buildConfig(ModConfigSpec.Builder spellBuilder) {
        super.buildConfig(spellBuilder);
        this.COOLDOWN = spellBuilder.comment("Cooldown for this prayer spell").defineInRange("cooldown", 0, 21000, Integer.MAX_VALUE);
        this.BASE_REP = spellBuilder.comment("Base reputation gained from this prayer spell").defineInRange("base_reputation", this.baseRep, 0, Integer.MAX_VALUE);
        this.POWER_MULTIPLIER = spellBuilder.comment("Altar Power multiplier for reputation gained with this prayer spell").defineInRange("power_multiplier", this.powerMultiplier, 0.0, Double.MAX_VALUE);
    }

    public int getCooldown() {
        return this.COOLDOWN == null ? 21000 : (Integer)this.COOLDOWN.get();
    }

    public int getBaseRep() {
        return this.BASE_REP == null ? this.baseRep : (Integer)this.BASE_REP.get();
    }

    public double getPowerMultiplier() {
        return this.POWER_MULTIPLIER == null ? this.powerMultiplier : (Double)this.POWER_MULTIPLIER.get();
    }
}

