/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.item;

import alexthw.eidolon_repraised.api.IDyeable;
import alexthw.eidolon_repraised.client.ClientRegistry;
import alexthw.eidolon_repraised.common.item.model.WarlockArmorModel;
import alexthw.eidolon_repraised.registries.EidolonMaterials;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarlockRobesItem
extends ArmorItem
implements IDyeable {
    public WarlockRobesItem(ArmorItem.Type slot, Item.Properties builderIn) {
        super(EidolonMaterials.WARLOCK_ROBES, slot, builderIn.stacksTo(1).durability(slot.getDurability(15)));
    }

    @NotNull
    public Component getName(@NotNull ItemStack pStack) {
        Component og = super.getName(pStack);
        if (this.getColor(pStack) == DyeColor.BLUE) {
            return og;
        }
        return Component.literal((String)(og.getString() + " (" + Component.translatable((String)this.getColor(pStack).getName()).getString() + ")"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public WarlockArmorModel getHumanoidArmorModel(@NotNull LivingEntity entity, @NotNull ItemStack itemStack, @NotNull EquipmentSlot armorSlot, @NotNull HumanoidModel _default) {
                float pticks = Minecraft.getInstance().getFrameTimeNs();
                float f = Mth.rotLerp((float)pticks, (float)entity.yBodyRotO, (float)entity.yBodyRot);
                float f1 = Mth.rotLerp((float)pticks, (float)entity.yHeadRotO, (float)entity.yHeadRot);
                float netHeadYaw = f1 - f;
                float netHeadPitch = Mth.lerp((float)pticks, (float)entity.xRotO, (float)entity.getXRot());
                ClientRegistry.WARLOCK_ARMOR_MODEL.slot = WarlockRobesItem.this.getEquipmentSlot();
                ClientRegistry.WARLOCK_ARMOR_MODEL.copyFromDefault(_default);
                ClientRegistry.WARLOCK_ARMOR_MODEL.setupAnim(entity, entity.walkAnimation.position(), entity.walkAnimation.speed(), (float)entity.tickCount + pticks, netHeadYaw, netHeadPitch);
                return ClientRegistry.WARLOCK_ARMOR_MODEL;
            }
        });
    }

    private DyeColor getColor(ItemStack stack) {
        return stack.has(DataComponents.BASE_COLOR) ? (DyeColor)stack.get(DataComponents.BASE_COLOR) : DyeColor.BLUE;
    }

    @Nullable
    public ResourceLocation getArmorTexture(@NotNull ItemStack stack, @NotNull Entity entity, @NotNull EquipmentSlot slot, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ArmorMaterial.Layer layer, boolean innerModel) {
        DyeColor dyeColor = this.getColor(stack);
        return ResourceLocation.fromNamespaceAndPath((String)"eidolon_repraised", (String)("textures/entity/warlock_robes/" + dyeColor.getName() + ".png"));
    }
}

