/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.capability;

import alexthw.eidolon_repraised.api.capability.IMana;
import alexthw.eidolon_repraised.registries.EidolonAttachments;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class PatronManaImpl
implements IMana {
    ManaData manaData;
    LivingEntity entity;

    public PatronManaImpl(LivingEntity entity) {
        this.entity = entity;
        this.manaData = (ManaData)entity.getData(EidolonAttachments.MANA_ATTACHMENT);
    }

    @Override
    public boolean hasMagic() {
        return this.manaData.maxMagic() > 0.0f;
    }

    @Override
    public float getMaxMagic() {
        return this.manaData.maxMagic();
    }

    @Override
    public float getMagic() {
        return this.manaData.magic();
    }

    @Override
    public void setMagic(float magic) {
        this.manaData.setMagic(Mth.clamp((float)magic, (float)0.0f, (float)this.manaData.maxMagic()));
        this.entity.setData(EidolonAttachments.MANA_ATTACHMENT, (Object)this.manaData);
    }

    @Override
    public void setMaxMagic(float max) {
        this.manaData.setMaxMagic(Math.max(0.0f, max));
        this.manaData.setMagic(Math.min(this.manaData.magic(), this.manaData.maxMagic()));
        this.entity.setData(EidolonAttachments.MANA_ATTACHMENT, (Object)this.manaData);
    }

    public static final class ManaData
    implements INBTSerializable<CompoundTag> {
        private float maxMagic;
        private float magic;

        public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            tag.putFloat("maxMagic", this.maxMagic);
            tag.putFloat("magic", this.magic);
            return tag;
        }

        public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            this.maxMagic = nbt.contains("maxMagic") ? nbt.getFloat("maxMagic") : 0.0f;
            this.magic = nbt.contains("magic") ? nbt.getFloat("magic") : 0.0f;
        }

        public float maxMagic() {
            return this.maxMagic;
        }

        public float magic() {
            return this.magic;
        }

        public void setMagic(float magic) {
            this.magic = magic;
        }

        public void setMaxMagic(float maxMagic) {
            this.maxMagic = maxMagic;
        }
    }
}

