/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.datagen;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.deity.Deity;
import alexthw.eidolon_repraised.common.deity.Deities;
import alexthw.eidolon_repraised.datagen.SimpleDataProvider;
import alexthw.eidolon_repraised.recipe.ChantConversionRecipe;
import alexthw.eidolon_repraised.registries.Registry;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EidChantConversionProvider
extends SimpleDataProvider {
    Map<ResourceLocation, ChantConversionRecipe> chants = new HashMap<ResourceLocation, ChantConversionRecipe>();

    public EidChantConversionProvider(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addConversions();
        for (Map.Entry<ResourceLocation, ChantConversionRecipe> recipe : this.chants.entrySet()) {
            Path path = EidChantConversionProvider.getRecipePath(this.output, recipe.getKey().getPath());
            this.saveStable(pOutput, (JsonElement)recipe.getValue().toJson(), path);
        }
    }

    protected void addConversions() {
        this.addConversion("convert_inlay_holy", Deities.LIGHT_DEITY, (Item)Registry.GOLD_INLAY.get(), ((Item)Registry.HOLY_SYMBOL.get()).getDefaultInstance(), 10.0f);
        this.addConversion("convert_inlay_unholy", Deities.DARK_DEITY, (Item)Registry.PEWTER_INLAY.get(), ((Item)Registry.UNHOLY_SYMBOL.get()).getDefaultInstance(), 10.0f);
        this.addConversion("convert_top_hat", null, Ingredient.of((ItemLike[])new ItemLike[]{Items.BLACK_WOOL}), ((Item)Registry.TOP_HAT.get()).getDefaultInstance(), 0.0f);
        this.addConversion("convert_disc", null, Ingredient.of((TagKey)Tags.Items.MUSIC_DISCS), ((Item)Registry.PAROUSIA_DISC.get()).getDefaultInstance(), 0.0f);
    }

    public void addConversion(String name, @Nullable Deity deity, Item input, ItemStack output, float minDevotion) {
        this.addConversion(name, deity, Ingredient.of((ItemLike[])new ItemLike[]{input}), output, minDevotion);
    }

    public void addConversion(String name, @Nullable Deity deity, Ingredient input, ItemStack output, float minDevotion) {
        this.chants.put(Eidolon.prefix(name), new ChantConversionRecipe(input, output, minDevotion, deity == null ? null : deity.getId()));
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/eidolon_repraised/recipe/" + str + ".json");
    }

    @NotNull
    public String getName() {
        return "Eidolon Conversion Chants";
    }
}

